<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\AffilierFormRequest;
use App\Http\Requests;
use App\Models\Affilier;
use App\Models\Partenaire;
use App\Models\AyantDroit;
use App\Models\Origine;
use App\Models\Service;
use App\Models\AffilierPartenaire;
use App\Models\Consomation;
use App\Models\Facture;
use Illuminate\Support\Facades\DB;
use App\Interfaces\IAffilie as IAffilie;
use App\Interfaces\IOrigine as IOrigine;
use App\Interfaces\IAyantDroit as IAyantDroit;
use App\Interfaces\IService as IService;
use App\Interfaces\IPartenaire as IPartenaire;
use PDF;
class AffilierController extends Controller
{

     public function __construct(IAffilie $Affilier, IOrigine $Origine, IAyantDroit $AyantDroit, IService $Service, IPartenaire $Partenaire){
        $this->Affilier = $Affilier;
        $this->Origine = $Origine;
        $this->AyantDroit = $AyantDroit;
        $this->Service = $Service;
        $this->Partenaire = $Partenaire;
        $this->middleware('guest');
      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    { 
       set_time_limit(600); // Extends to 5 minutes. 
       //$Affiliers = $this->Affilier->fetchtAll();
       $Origines = $this->Origine->fetchtAll();
       return view('Affiliers.index', compact('Origines'));
    } 

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $Origines = $this->Origine->fetchtAll();
        $Affilier = new Affilier;
        $Ori = new Origine;
        return view ('Affiliers.create', compact('Origines', 'Affilier', 'Ori'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(AffilierFormRequest $request)
    {    
        $this->Affilier->saveData($request, null);
        return redirect(route('Affiliers.index')); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

       $Affilier = $this->Affilier->showData($id);
       $AyantDroits = $this->AyantDroit->selectayantdroitbyaffilier($id);
       

    $Partenaires = DB::table('affilier_partenaires')
                    ->join('partenaires', 'affilier_partenaires.Partenaire', '=', 'partenaires.id')
                     ->join('services', 'affilier_partenaires.Service', '=', 'services.id')
                     ->select(DB::raw('partenaires.id,partenaires.Type, partenaires.Partenaire,partenaires.created_at,affilier_partenaires.Affilier,affilier_partenaires.Etat,affilier_partenaires.SA,affilier_partenaires.Hospitalisation,affilier_partenaires.Service as SAP, services.Service'))
                     ->whereAffilier($id)
                     ->where('affilier_partenaires.Etat',0)
                     ->get();

     $ServiceAff = $this->Service->fetchtAll(); 

    $PartNonAccess = $this->Partenaire->fetchtAll();            
    $Origine = $this->Origine->showData($Affilier->Origine);

    return view('Affiliers.show', compact('Affilier', 'AyantDroits', 'Partenaires', 'Origine', 'id', 'PartNonAccess', 'ServiceAff')); 
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $Affilier = $this->Affilier->showData($id);
        $Ori = $this->Origine->showData($Affilier->Origine);
        $Origines = $this->Origine->fetchtAll();
        return view('Affiliers.edit', compact('Affilier', 'Ori', 'Origines'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(AffilierFormRequest $request, $id)
    {

       $this->Affilier->saveData($request, $id);

        return redirect( route('Affiliers.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $this->Affilier->deleteData($id);
       return redirect(route('Affiliers.index')); 
     }

     // Fonction pour la suppression definitive de l'enregistrement.

     public function SupprimerDef($id)
     {
       $Affilier = $this->Affilier->showData($id);
    
        $Affilier->update([
            'Etat' => 2
        ]);
       session()->flash('messageDelete', 'Cet Affilier a été supprimé');
        return redirect(route('CorbAffil'));
     }

     public function CorbAffil()
     {
        $Affiliers = Affilier::whereEtat(1)->get();   
        return view('Affiliers.Corbeille', compact('Affiliers'));
     }

     public function RestaureAff($id)
     {
        $Affilier = $this->Affilier->showData($id);
        $Affilier->update([
            'Etat' =>0
        ]);

        return redirect(route('CorbAffil'));
     }



     public function AffilierPartenaire(Request $request)
     {  
        set_time_limit(0);
        $Affilier =$request->Affilier;
        //Cas du Bouton Ajouter

        if (isset($request->Ajouter)) {
            $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire, $request->Service)->count();

            //1. Cas D'attribution par groupe et Tout les services
             if (isset($request->Groupe) && !empty($request->Groupe) && $request->Groupe !='Moimeme' && isset($request->Service) && !empty($request->Service) && $request->Service =='Tout') 
             {
                $Affiliers = Affilier::whereEtatAndOrigine(0,$request->Groupe)->get();
                foreach ($Affiliers as $Affilier) 
                {
                    $Services = Service::whereEtat(0)->get(); 
                    foreach ($Services as $Service) 
                    {
                    $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire, $Service->id)->count();

                    if ($Nbre==0) { 
                    AffilierPartenaire::create([
                    'Affilier' => $Affilier->id,
                    'Partenaire' => $request->Partenaire,
                    'Service' => $Service->id
                    ]);
                    }else{
                    $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire,$Service->id)->first();
                    if ($Detail->Etat==1) 
                    {
                      $Detail->update([
                       'Etat' =>0
                      ]);  
                    }
                  } 
                }
              }
            }//2.Cas D'attribution par groupe et un service
             elseif (isset($request->Groupe) && !empty($request->Groupe) && $request->Groupe !='Moimeme' && isset($request->Service) && !empty($request->Service) && $request->Service !='Tout') 
             {
                $Affiliers = Affilier::whereEtatAndOrigine(0,$request->Groupe)->get();
                foreach ($Affiliers as $Affilier) 
                {
                $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire, $request->Service)->count();

                    if ($Nbre==0) { 
                    AffilierPartenaire::create([
                    'Affilier' => $Affilier->id,
                    'Partenaire' => $request->Partenaire,
                    'Service' => $request->Service
                    ]);
                    }else{
                    $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire,$request->Service)->first();
                    if ($Detail->Etat==1) 
                    {
                      $Detail->update([
                       'Etat' =>0
                      ]);  
                    }
                  } 
                }
              }//3.Cas D'attribution par personne et +++ Services
             elseif (isset($request->Groupe) && !empty($request->Groupe) && $request->Groupe =='Moimeme' && isset($request->Service) && !empty($request->Service) && $request->Service =='Tout') 
             {
                $Services = Service::whereEtat(0)->get();
                foreach ($Services as $Service) 
                {
                $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire, $Service->id)->count();

                    if ($Nbre==0) { 
                    AffilierPartenaire::create([
                    'Affilier' => $request->Affilier,
                    'Partenaire' => $request->Partenaire,
                    'Service' => $Service->id
                    ]);
                    }else{
                    $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire,$Service->id)->first();
                    if ($Detail->Etat==1) 
                    {
                      $Detail->update([
                       'Etat' =>0
                      ]);  
                    }
                  } 
                }
              }
              //4.Cas D'attribution par personne et Service
              else
              {  
            $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire, $request->Service)->count();

                    if ($Nbre==0) { 
                    AffilierPartenaire::create([
                    'Affilier' => $request->Affilier,
                    'Partenaire' => $request->Partenaire,
                    'Service' => $request->Service
                    ]);
                    }else{
                    $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire,$request->Service)->first();
                    if ($Detail->Etat==1) 
                    {
                      $Detail->update([
                       'Etat' =>0
                      ]);  
                    }
                  } 
             }
       
        }   
       return redirect(route('Affiliers.show', compact('Affilier')));    
     }

    public function AffilierPatenerD(Request $request)
    {    
        set_time_limit(0);
        $Affilier = $request->Affilier;
        //Cas De Suppression Par GROUPE 
        if (isset($request->Groupe) && !empty($request->Groupe) && $request->Groupe !='Moimeme') 
        {   
            //On recupere tous les affilies appartenant a ce groupe
            $Affiliers = Affilier::whereEtatAndOrigine(0,$request->Groupe)->get();

            //Cas de Suppression de tous les service
            if (isset($request->Service) && !empty($request->Service) && $request->Service =='All') {
                
                //On parcour le tableau des affilies
                foreach ($Affiliers as $Affilier) 
                { 

                    //On recupere tous les services fournis par les partenaire chez cet affilié
                    $Services = AffilierPartenaire::whereAffilierAndPartenaire($Affilier->id,$request->Partenaire)->get(); 

                    //On parcour les tableau de service du partenaire pour verifié si reellement ce service existe chez l'affilié
                    foreach ($Services as $Service) {
                        $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire, $Service->Service)->count();

                        if ($Nbre>0) 
                        {
                            $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire,$Service->Service)->first();
        
                            $Detail->update([
                            'Etat' =>1
                            ]);   
                        } 
                    }  
                }     
            }
            else
            {
               
                //On parcour le tableau des affilies
                foreach ($Affiliers as $Affilier) 
                { 
                    $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire, $request->Service)->count();

                    if ($Nbre>0) 
                    {
                        $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($Affilier->id, $request->Partenaire,$request->Service)->first();
        
                        $Detail->update([
                            'Etat' =>1
                        ]);   
                    }   
                } 
            }
            
        }
        else
        {
            $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire, $request->Service)->count();
            
            //Cas de Suppression de tous les service
            if (isset($request->Service) && !empty($request->Service) && $request->Service =='All') {
                //On recupere tous les services fournis par les partenaire chez cet affilié
                $Services = AffilierPartenaire::whereAffilierAndPartenaire($request->Affilier,$request->Partenaire)->get(); 

                //On parcour les tableau de service du partenaire pour verifié si reellement ce service existe chez l'affilié
                foreach ($Services as $Service) {
                    $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire, $Service->Service)->count();

                    if ($Nbre>0) 
                    {
                        $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire,$Service->Service)->first();
        
                        $Detail->update([
                            'Etat' =>1
                        ]);   
                    } 
                } 
            }
            else
            {
               
                $Nbre = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire, $request->Service)->count();
                    if ($Nbre>0) 
                    {
                        $Detail = AffilierPartenaire::whereAffilierAndPartenaireAndService($request->Affilier, $request->Partenaire,$request->Service)->first();
        
                        $Detail->update([
                            'Etat' =>1
                        ]);   
                    }   
            } 
        }
 
        return redirect(route('Affiliers.show', compact('Affilier')));    
    }

     public function PdfListeAffilie(Request $request)
     {  
        set_time_limit(1200);
        $Consomation = Consomation::findOrFail(1);
           $NbreAD =0;  
            $table="";
            $AyaDrA="";
        if (isset($request->Origine) && !empty($request->Origine)) 
        {
             $NbreAff = Affilier::whereEtatAndOrigine(0,$request->Origine)->count();
          
             if ($NbreAff > 0) {

             $Affiliers = Affilier::whereEtatAndOrigine(0,$request->Origine)->get();
             $SommeOrigine = Affilier::whereEtatAndOrigine(0,$request->Origine)->sum('CotisationM');
             foreach($Affiliers as $Aff){
            $id_Origine=$Aff->Origine;
            $AyantDroits = AyantDroit::whereEtatAndAffilier(0,$Aff->id)->get();

            $NAyantDroits = AyantDroit::whereEtatAndAffilier(0,$Aff->id)->where('Lien', '!=', 'Lui meme')->count();
            $NbreAD += $NAyantDroits;

            foreach ($AyantDroits as $AyantDroit) 
            {  
               if ($AyantDroit->Lien != 'Lui meme') 
               {
                  $AyaDrA.="
                 <ul><li>".$AyantDroit->Nom.' '.$AyantDroit->Prenom."</li></ul>";
               }   
            }
              $Origine=Origine::where('id',$id_Origine)->first();
        
            $TAyaDrA=$AyaDrA;
            $AyaDrA="";
            $table.="
                    <tr class='odd gradeX'>
                        <td>".$Aff->Code."</td>
                        <td>".$Aff->Nom.' '.$Aff->Prenom."</td>
                        <td>".$TAyaDrA."</td>
                        <td>".$Aff->Adresse."</td>
                        <td>".$Aff->DateNaiss."</td>
                        <td>".$Origine->Origine."</td>
                        <td>".$Aff->DateEntree."</td>
                        <td>".$Aff->CotisationM."</td>
                        <td>".$Aff->SoinsAmbilatoire.'%'."</td>
                        <td>".$Aff->PlafondChambre.'%  avec '.$Aff->PCNuit.' FBU /Nuitée'."</td>
                        <td>".$Aff->UniteMaternite.' FBU'."</td>
                        <td>".$Aff->Pharmacie.' FBU'."</td>
        </tr>";   
    }
        }
        $tableListe=$table;
         $pdf = PDF::loadView('Affiliers.PdfListeAffilie', compact('tableListe', 'Origine', 'Consomation', 'SommeOrigine', 'NbreAD', 'NbreAff'))->setPaper('a2', 'Paysage');
         $fileName = 'Affiliers';
         return $pdf->stream($fileName . '.pdf');
     }
     else
     {
            $NbreAff = Affilier::whereEtat(0)->count();  
            $Origine= NEW Origine;
            $table="";
            if ($NbreAff > 0) {
            $SommeOrigine = Affilier::whereEtat(0)->sum('CotisationM');
            $Affiliers = Affilier::whereEtat(0)->get();

          foreach($Affiliers as $Aff){

               $id_Origine=$Aff->Origine;
            
                $AyantDroits = AyantDroit::whereEtatAndAffilier(0,$Aff->id)->get();
                $NAyantDroits = AyantDroit::whereEtatAndAffilier(0,$Aff->id)->where('Lien', '!=', 'Lui meme')->count();
                $NbreAD += $NAyantDroits;
             
             foreach ($AyantDroits as $AyantDroit) 
            {  
               if ($AyantDroit->Lien != 'Lui meme') 
               {
                  $AyaDrA.="
                  <ul><li>".$AyantDroit->Nom.' '.$AyantDroit->Prenom."</li></ul>";
               }   
            }
            
            //$Origine=Origine::where('id',$id_Origine)->first();
            $TAyaDrA=$AyaDrA;
            $AyaDrA="";
            $table.="
                    <tr class='odd gradeX'>
                        <td>".$Aff->Code."</td>
                        <td>".$Aff->Nom.' '.$Aff->Prenom."</td>
                        <td>".$TAyaDrA."</td>
                        <td>".$Aff->Adresse."</td>
                        <td>".$Aff->DateNaiss."</td>
                        <td>".$Origine->Origine."</td>
                        <td>".$Aff->DateEntree."</td>
                        <td>".$Aff->CotisationM."</td>
                        <td>".$Aff->SoinsAmbilatoire.'%'."</td>
                        <td>".$Aff->PlafondChambre.'%  avec '.$Aff->PCNuit.' FBU /Nuitée'."</td>
                        <td>".$Aff->UniteMaternite.' FBU'."</td>
                        <td>".$Aff->Pharmacie.' FBU'."</td>
        </tr>";   
    $tableListe=$table;
    }
   
        }
         $pdf = PDF::loadView('Affiliers.PdfListeAffilie', compact('tableListe', 'Consomation', 'Origine', 'NbreAff', 'NbreAD', 'SommeOrigine'))->setPaper('a2', 'Paysage');
         $fileName = 'Affiliers';
         return $pdf->stream($fileName . '.pdf');
     }    
}

  
  // Creer Une Nouvelle Facture
  public function addBillForm($Aff)
  { 
    $AyantDroits = AyantDroit::whereAffilierAndEtat($Aff,0)->get();
    if (session()->get('Profil') == 'Partenaire') 
    {
      $AffilierPartenaire = DB::table('affilier_partenaires')
                     ->join('services' , 'services.id', '=', 'affilier_partenaires.Service')
                     ->join('partenaires', 'partenaires.id', '=', 'affilier_partenaires.Partenaire')
                     ->select(DB::raw('services.service,services.Traitement, partenaires.Partenaire'))
                    ->where('affilier_partenaires.Partenaire',session()->get('id'))
                    ->whereAffilier($Aff)
                    ->where('affilier_partenaires.Etat',0)
                    ->get();          

        $Services = DB::table('affilier_partenaires')
                     ->join('services' , 'services.id', '=', 'affilier_partenaires.Service')
                     ->select(DB::raw('services.id,services.service, services.Traitement'))
                    ->wherePartenaire(session()->get('id'))
                    ->whereAffilier($Aff)
                    ->where('affilier_partenaires.Etat',0)
                    ->where('services.Etat',0)
                    ->get();                        
    }
    else
    {


    $AffilierPartenaire = DB::table('affilier_partenaires')
                     ->join('services' , 'services.id', '=', 'affilier_partenaires.Service')
                     ->join('partenaires', 'partenaires.id', '=', 'affilier_partenaires.Partenaire')
                     ->select(DB::raw('services.service,services.Traitement, partenaires.Partenaire'))
                    ->whereAffilier($Aff)
                    ->where('affilier_partenaires.Etat',0)
                    ->get();  

    $Services = DB::table('affilier_partenaires')
                    ->join('services' , 'services.id', '=', 'affilier_partenaires.Service')
                    ->select(DB::raw('DISTINCT(services.id),services.service, services.Traitement'))
                    //->wherePartenaire(session()->get('id'))
                    ->whereAffilier($Aff)
                    ->where('affilier_partenaires.Etat',0)
                    ->where('services.Etat',0)
                    ->get();                                  


    }
    $Partenaires = Partenaire::whereEtat(0)->get();
    return view('Affiliers.addBillForm', compact('Aff', 'AyantDroits', 'Partenaires','AffilierPartenaire', 'Services'));
  }

//   public function PostImportAffilier(Request $request){
// set_time_limit(0);                
// $extensions = array("xls","xlsx","xlm","xla","xlc","xlt","xlw", "csv");
// $result = array($request->file('fichier')->getClientOriginalExtension());

// if(in_array($result[0],$extensions)){
//      // Do something when Succeeded 

//   $data = Excel::load(Input::file('fichier'), function($reader) {})->get();
//         if(!empty($data) && $data->count()){
//         foreach ($data->toArray() as $key => $value) {

//     $CurrentYear = date('Y');


           
//       //On verifie si toutes les colonnes de notre fichier sont remplies
//         if (!empty($value['code']) && !empty($value['nom']) && !empty($value['prenom']) && !empty($value['origine']) && !empty($value['dateentree']) && !empty($value['cotisation']) && !empty($value['soinsambilatoire']) && !empty($value['plafondchambre']) && !empty($value['pc/nuit']) && !empty($value['unitematernite']) && !empty($value['elseunitematernite']) && !empty($value['pharmacie']) && !empty($value['annee']) && !empty($value['pieceindentite']) && !empty($value['telephone']) && !empty($value['datenaiss']) && !empty($value['lunette']) && !empty($value['dents']) && !empty($value['hospitalisation']) && !empty($value['imagerie']) && !empty($value['reanimation']) && !empty($value['kinesie']) && !empty($value['labo']) && !empty($value['adresse']) && !empty($value['medicament'])) {
//           //Verification de doublons  

//         $NbreCode = Affilier::whereCode($value['code'])->where('Etat', '!=', 2)->count('id');
//         $NbrePiece = Affilier::wherePieceindentite($value['pieceindentite'])->count('id');


//            if ($NbreCode == 0) 
//            {  
       
//               if ($NbrePiece == 0) 
//               {

//             Affilier::create([
//             'Code' => $request->Code,
//             'Nom' => $request->Nom,
//             'Prenom' => $request->Prenom,
//             'Origine' => $request->Origine,
//             'DateEntree' => $request->DateEntree,
//             'CotisationM' => $request->Cotisation,
//             'SoinsAmbilatoire' => $request->SA,
//             'PlafondChambre' => $request->HPC,
//             'PCNuit' => $request->HPCN,
//             'UniteMaternite' => $request->Maternite,
//             'ElseUniteMaternite' => $request->MaterniteP,
//             'Pharmacie' => $request->Pharmacie,
//             'Annee' => $CurrentYear,
//             'PieceIndentite' => $request->Piece,
//             'Telephone' => $request->Telephone,
//             'DateNaiss' => $request->DateNaiss,
//             'Lunette' => $request->Lunette,
//             'dents' => $request->dents,
//             'Hospitalisation'=>$request->Hospitalisation,
//             'imagerie'=>$request->Imagerie,
//             'reanimation'=>$request->Reanimation,
//             'kinesie'=>$request->Kinesitherapie,
//             'labo'=>$request->Laboratoire,
//             'Adresse' => $request->Adresse,
//             'Medicament' => $request->Medicament
//         ]);
        
//         $MaxId = Affilier::all()->max('id');

//         AyantDroit::create([
//             'Affilier' =>$MaxId,
//             'Nom' => $request->Nom,
//             'Prenom' => $request->Prenom,
//             'Lien' => 'Lui meme'
//         ]);
         
//     }
         
//           session()->flash('message', 'Fichier chargé completement avec success, '. $data->count().' Enregistrements ont été ajoutés');
//         }else{
//            session()->flash('messageDelete', 'Erreur de chargement vous avez tenté de Changer un fichier vide ou incomplet');
//         }    
//      }
//     }
//   }
// else{
//    session()->flash('messageDelete', 'Erreur pendant le Telechargement du fichier');
// }
//   return back(); 
// }
// }

      public function research(Request $request){
        $Affilier=$request->get('affilie');
        $Affiliers = DB::table('affiliers')
            ->join('origines', 'affiliers.Origine', '=', 'origines.id')
            ->select(DB::raw('affiliers.id,affiliers.Code, affiliers.Nom, affiliers.Prenom, origines.Origine'))
            ->where('affiliers.Code','=',$Affilier)->get();
            
        $allAffilier="";
        
        foreach ($Affiliers as $A) {
            $allAffilier.="<tr class='odd gradeX'>
                                <td>".$A->Code."</td>
                                <td>".$A->Nom."</td>
                                <td>".$A->Prenom."</td>
                                <td>".$A->Origine."</td>
                                <td>
                                    <a href=".route('Affiliers.show', $A->id)."><i class='fa fa-eye'></i></a>
                                    <a href=".route('addBillForm', $A->id)."><i class='fa fa-plus'></i></a>
                                </td>
                            </tr>";
        }
        echo $allAffilier;
        
    }
}      
  