<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use\App\Http\Requests\ComptePrincipalRequest;
use App\Http\Requests;
use\App\Models\ComptePrincipal;
use\App\Models\CodeJournaux;
use\App\Models\CompteJournal;
use\App\Models\Type;
use Illuminate\Support\Facades\DB;
use PDF;
class ComptePrincipalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $Types = Type::whereEtat(0)->get();
        $CodeJournaux = CodeJournaux::whereEtat(0)->get();
        $Comptes =DB::table('types')
                 ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                 ->select(DB::raw('compte_principals.id,compte_principals.NumeroCompte, compte_principals.Intitule,types.Types'))
                 ->where('types.Etat', 0)
                 ->where('compte_principals.Etat', 0) 
                 ->get();
        
        $table="";

        foreach ($Comptes as $Compte) {
            $table.="
              <tr>
               <td>".$Compte->id."</td>
               <td>".$Compte->NumeroCompte."</td>
               <td>".$Compte->Intitule."</td>
               <td>".$Compte->Types."</td>
               <td>
               <a href='".route('ComptePrincipal.edit', $Compte->id)."'><i class='fas fa-edit'></i></a>
              <form action='".route('ComptePrincipal.destroy', $Compte->id)."' method='POST' style='display: inline-block;' onsubmit='return confirm('Etez-vous sur de cette Operation ?')'>
                    ".csrf_field()."
                     ".method_field('DELETE')."
                <button onclick='return confirm('Etez -vous sur de cette Operation ?')'><i class='fas fa-trash'></i>
               </button>
               </form>
              </td>
             </tr>";
           }
          $tableListe = $table; 
        return view('Comptabilite/ComptePrincipal.index', compact('tableListe', 'Types', 'CodeJournaux'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ComptePrincipalRequest $request)
    {  
       if (ComptePrincipal::UniqueCompte($request->Numero)) {
          if (empty($request->Categorie)) {
               ComptePrincipal::create([
            'NumeroCompte'=>$request->Numero,
            'Intitule'=>$request->Intitule,
            'TypeCompte'=>$request->TypeCompte,
            'Categorie'=>""
           ]);
            }else{
                 ComptePrincipal::create([
            'NumeroCompte'=>$request->Numero,
            'Intitule'=>$request->Intitule,
            'TypeCompte'=>$request->TypeCompte,
            'Categorie'=>$request->Categorie
           ]);
            }

            //Insertion dans la table de Liaison    
        } 

        return redirect(route('ComptePrincipal.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Types = Type::whereEtat(0)->get();
        $ComptePrincipal = ComptePrincipal::findOrFail($id);
        $Type=Type::findOrFail($ComptePrincipal->TypeCompte);
        return view('Comptabilite/ComptePrincipal.edit', compact('Types', 'ComptePrincipal', 'Type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ComptePrincipalRequest $request, $id)
    {
        $ComptePrincipal=ComptePrincipal::findOrFail($id);
         if (empty($request->Categorie)) {
               $ComptePrincipal->update([
            'NumeroCompte'=>$request->Numero,
            'Intitule'=>$request->Intitule,
            'TypeCompte'=>$request->TypeCompte,
            'Categorie'=>""
           ]);
            }else{
            $ComptePrincipal->update([
            'NumeroCompte'=>$request->Numero,
            'Intitule'=>$request->Intitule,
            'TypeCompte'=>$request->TypeCompte,
            'Categorie'=>$request->Categorie
           ]);
        }
         return redirect(route('ComptePrincipal.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Compte = ComptePrincipal::findOrFail($id);
        $Compte->update([
            'Etat'=>1
        ]);

        return redirect(route('ComptePrincipal.index'));
    }
}
