<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use\App\Http\Requests\CompteSudivisionnaireRequest;
use App\Http\Requests;
use\App\Models\CompteSubdivisionnaire;
use Illuminate\Support\Facades\DB;
use PDF;
use\App\Models\ComptePrincipal;
class CompteSudbivisionnaireController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Comptes = ComptePrincipal::whereEtat(0)->get();
        $SComptes =DB::table('compte_subdivisionnaires')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('compte_subdivisionnaires.id, compte_subdivisionnaires.NumeroCompte as S, compte_subdivisionnaires.Intitule,compte_principals.NumeroCompte as P'))
                  ->where('compte_subdivisionnaires.Etat', '=', 0)
                  ->get();
        $table = "";
        foreach ($SComptes as $SCompte) 
        {
            $table.="
              <tr>
                <td>".$SCompte->id."</td>
                <td>".$SCompte->S."</td>
                <td>".$SCompte->Intitule."</td>
                <td>".$SCompte->P."</td>
                <td>
              <a href='".route('Comptedivisionnaire.edit', $SCompte->id)."'><i class='fas fa-edit'></i></a>  
              <form action='".route('Comptedivisionnaire.destroy', $SCompte->id)."' method='POST' style='display: inline-block;' onsubmit='return confirm('Etez-vous sur de cette Operation ?')'>
                    ".csrf_field()."
                     ".method_field('DELETE')."
                <button onclick='return confirm('Etez -vous sur de cette Operation ?')'><i class='fas fa-trash'></i>
               </button>
               </form>
                </td>
              </tr>
            ";
        }
        $tableListe = $table;
        return view('Comptabilite/Comptedivisionnaire.index', compact('tableListe', 'Comptes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CompteSudivisionnaireRequest $request)
    {  
       if (CompteSubdivisionnaire::UniqueCompte($request->Numero)==true) {
             CompteSubdivisionnaire::create([
            'NumeroCompte'=>$request->Numero,
            'Intitule'=>$request->Intitule,
            'ComptePricipal'=>$request->Compte
        ]);
        } 
        return redirect(route('Comptedivisionnaire.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $Comptes = ComptePrincipal::whereEtat(0)->get();
        $SCompte = CompteSubdivisionnaire::findOrFail($id);
        $Compte = ComptePrincipal::findOrFail($SCompte->ComptePricipal);
        return view('Comptabilite/Comptedivisionnaire.edit', compact('Comptes', 'SCompte', 'Compte'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(CompteSudivisionnaireRequest $request, $id)
    {
         $SCompte=CompteSubdivisionnaire::findOrFail($id);
          $SCompte->update([
            'NumeroCompte'=>$request->Numero,
            'Intitule'=>$request->Intitule,
            'ComptePricipal'=>$request->Compte
        ]);
         return redirect(route('Comptedivisionnaire.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $SCompte = SCompte::findOrFail($id);
        $SCompte->update([
            'Etat'=>1
        ]);
        return redirect(route('Comptedivisionnaire.index'));
    }
}
