<?php

namespace App\Http\Controllers;
use\App\Http\Requests\ExerciceComptableRequest;
use Illuminate\Http\Request;
use App\Http\Requests;
use\App\Models\ExerciceComptable;
use\App\Models\ComptePrincipal;
use\App\Models\Repportage;
use\App\Models\CompteRepport;
use Illuminate\Support\Facades\DB;
class ExerciceComptableController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $Ex = New ExerciceComptable;
        $Exercices = ExerciceComptable::whereEtat(0)->get();
        return view('Comptabilite/ExerciceComptable.index', compact('Exercices', 'Ex'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ExerciceComptableRequest $request)
    {  
       $NbreEx = ExerciceComptable::whereEtatAndCloturer(0,0)->count('id'); 
       if (ExerciceComptable::UniqueExercice($request->Debut,$request->Fin) == true) {

          if (ExerciceComptable::VerifyseparateurDecimalseparateurMilieu($request->SeparateurDecimal,$request->SeparateurMilieu)== true) {

            if (ExerciceComptable::VerifyNbreDecimal($request->NbreDecimal)== true ) {

                if ($NbreEx==0) {

                  ExerciceComptable::create([
                  'Debut'=>$request->Debut,
                  'Fin'=>$request->Fin,
                  'NbreDecimal'=>$request->NbreDecimal,
                  'separateurDecimal'=>$request->SeparateurDecimal,
                  'separateurMilieu'=>$request->SeparateurMilieu,
                  'Devise'=>$request->Devise,
                   ]);
                  $LastExercice = ExerciceComptable::whereEtat(0)->max('id');

                  //ON RECUPERE TOUS LES DONNEES A REPORTER
                  $Repportage = Repportage::whereReportedIn(0)->get();
                  //ON DEBUTER LE REPORTAGE DES DONNEES
                  foreach ($Repportage as $Repport) {
                      $Repport->update([
                        'reported_in'=>$LastExercice
                      ]);
                  }
                }else{
                  session()->flash('messageDelete', 'Un autre Exercice est ouvert, Veuillez le Cloturer!');
                }
            }else{
                session()->flash('messageDelete', ' Le nombre de decimal doit etre compris entre 0 a 9');
            }
        }else{
           session()->flash('messageDelete', ' Le separateur Milieu et decimal doivent prendre la valeur , ou .'); 
        } 
       
     }else{
          session()->flash('messageDelete', 'Cet Exercice Comptable Existe!');
     }  
    return redirect(route('ExerciceComptable.index'));
  }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $ExerciceComptable = ExerciceComptable::findOrFail($id);
        return view('Comptabilite/ExerciceComptable.edit', compact('ExerciceComptable'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ExerciceComptableRequest $request, $id)
    {   
        $ExerciceComptable = ExerciceComptable::findOrFail($id);
        $ExerciceComptable->update([
            'Debut'=>$request->Debut,
            'Fin'=>$request->Fin,
            'NbreDecimal'=>$request->NbreDecimal,
            'separateurDecimal'=>$request->SeparateurDecimal,
            'separateurMilieu'=>$request->separateurMilieu,
            'Devise'=>$request->Devise,
        ]);
        return redirect(route('ExerciceComptable.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $ExerciceComptable = ExerciceComptable::findOrFail($id);
         $ExerciceComptable->update([
            'Etat'=>1
         ]);

         return redirect(route('ExerciceComptable.index'));
    }

    //Cloturer et Reouverture L'exercice Comptable 
    public function CloseExercice(Request $request){
        $ExerciceComptable = ExerciceComptable::findOrFail($request->Exerciceid);
        $NbreEx = ExerciceComptable::whereEtatAndCloturer(0,0)->count('id');    
        //Cas de cloture de l'exercice comptable
        if ($ExerciceComptable->Cloturer==0) {

            if ($request->optioncheck==2) {
                    
                
            }elseif ($request->optioncheck==3) {
                # code...
            }else{
                $Comptes = DB::table('compte_principals')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                ->select(DB::raw('sum(MD) as MD, sum(MC) as MC,compte_principals.Intitule,compte_principals.id'))
                ->groupBy('compte_principals.id')
                ->get();
                 
                foreach ($Comptes as $Compte) {
                $montant = $Compte->MD-$Compte->MC;

            //ON RECUPERE LE MONTANT DU REPPORT A NOUVEAU DE L'EXERCICE A CLOTURER
             $NbreRepport = DB::table('compte_principals')
                ->join('compte_report_comptes', 'compte_report_comptes.compte_principale_id', '=', 'compte_principals.id')
                ->join('repportages', 'repportages.compte_id', '=', 'compte_report_comptes.id')
                ->select(DB::raw('repportages.montant'))
                ->where('compte_principals.id', $Compte->id)
                ->where('repportages.reported_in', session()->get('ExerciceComptableId'))
                ->count('repportages.id'); 

                if ($NbreRepport>0) {
                    $montantR = DB::table('compte_principals')
                    ->join('compte_report_comptes', 'compte_report_comptes.compte_principale_id', '=', 'compte_principals.id')
                    ->join('repportages', 'repportages.compte_id', '=', 'compte_report_comptes.id')
                    ->select(DB::raw('repportages.montant'))
                    ->where('compte_principals.id', $Compte->id)
                    ->where('repportages.reported_in', session()->get('ExerciceComptableId'))
                    ->first();
                    $montant += $montantR->montant;
                }      
                
                
                
                    if($montant>0){
                  
                $NbreC = DB::table('compte_principals')
                ->join('compte_report_comptes', 'compte_report_comptes.compte_principale_id', '=', 'compte_principals.id')
                ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                ->select(DB::raw('compte_report_comptes.id'))
                ->where('compte_repports.Type_compte', 'Debiteur')
                ->where('compte_principals.id', $Compte->id)
                ->count('compte_report_comptes.id');

                if ($NbreC>0) {
                     $reportedAccount = DB::table('compte_principals')
                ->join('compte_report_comptes', 'compte_report_comptes.compte_principale_id', '=', 'compte_principals.id')
                ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                ->select(DB::raw('compte_report_comptes.id'))
                ->where('compte_repports.Type_compte', 'Debiteur')
                ->where('compte_principals.id', $Compte->id)
                ->first(); 

                      Repportage::create([
                                'exercice_id'=>session()->get('ExerciceComptableId'),
                                'compte_id'=>$reportedAccount->id,
                                'montant'=>$montant
                            ]);
                       
                }    
                       
                    
                        }else if($montant<0){

                        $nbreCp = DB::table('compte_principals')
                            ->join('compte_report_comptes', 'compte_report_comptes.compte_principale_id', '=', 'compte_principals.id')
                            ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                            ->select(DB::raw('compte_report_comptes.id'))
                            ->where('compte_repports.Type_compte', 'Crediteur')
                            ->where('compte_principals.id', $Compte->id)
                            ->count('compte_report_comptes.id');
                          if($nbreCp>0){
                             $reportedAccount = DB::table('compte_principals')
                            ->join('compte_report_comptes', 'compte_report_comptes.compte_principale_id', '=', 'compte_principals.id')
                            ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                            ->select(DB::raw('compte_report_comptes.id'))
                            ->where('compte_repports.Type_compte', 'Crediteur')
                            ->where('compte_principals.id', $Compte->id)
                            ->first();

                            Repportage::create([
                                'exercice_id'=>session()->get('ExerciceComptableId'),
                                'compte_id'=>$reportedAccount->id,
                                'montant'=>$montant
                            ]);
                          }
                            
                        }
                    } 
                }
                $ExerciceComptable->update([
               'Cloturer'=>1
               ]);
            }
        return redirect(route('ExerciceComptable.index'));
    }


    public function ReouvrirExercice($Exerciceid){
          $NbreEx = ExerciceComptable::whereEtatAndCloturer(0,0)->count('id');  
          $ExerciceComptable = ExerciceComptable::findOrFail($Exerciceid);
         //On verifie s'il y a un autre exercice ouvert
           if ($NbreEx==0) {
                $ExerciceComptable->update([
               'Cloturer'=>0
             ]);

             //Creation de la nouvelle session contenant l'Exercice reouverte
            $Exercice = ExerciceComptable::whereEtatAndCloturer(0,0)->first(); 
            session()->put('ExerciceComptableId', $Exercice->id);
            session()->put('ExerciceComptableDebut', $Exercice->Debut);
            session()->put('ExerciceComptableFin', $Exercice->Fin);
               
            }else{
            session()->flash('messageDelete', 'Un autre Exercice est ouvert, Veuillez le Cloturer!');
            }   
         return redirect(route('ExerciceComptable.index'));
    }
}
