<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use\App\Http\Requests\JournalRequest;
use App\Http\Requests;
use\App\Models\CompteSubdivisionnaire;
use Illuminate\Support\Facades\DB;
use PDF;
use\App\Models\ExerciceComptable;
use\App\Models\ComptePrincipal;
use\App\Models\Journal;
use\App\Models\CodeJournaux;
use\App\Models\Type;
class JournalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $Exe = ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));
        $ComptePrincipals = ComptePrincipal::whereEtat(0)->get();
        $CompteSubdivisionnaires = CompteSubdivisionnaire::whereEtat(0)->get();
        $Journal = New Journal;
        $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id') 
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,journals.Libelle,journals.TypeMvt,journals.Piece, journals.DateOperation'))
                  ->where('journals.Etat', 0)
                  ->where('journals.Exercice', session()->get('ExerciceComptableId'))
                  ->get();
        $MD = Journal::whereEtatAndExercice(0,session()->get('ExerciceComptableId'))->sum('MD');
        $MC = Journal::whereEtatAndExercice(0,session()->get('ExerciceComptableId'))->sum('MC');

        $table ="";
        foreach ($Journals as $Journal) {
           if ($Journal->TypeMvt ==1) 
           { 
            $table.="<tr>
             <td>".$Journal->DateOperation."</td>
             <td>".$Journal->Piece."</td>
             <td>".$Journal->NumeroCompte."</td>
             <td></td>
             <td>".$Journal->Libelle."</td>
             <td>".number_format($Journal->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($Journal->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td> <a href='".route('Journal.edit', $Journal->id)."'><i class='fas fa-edit'></i></a>
                         <form action='".route('Journal.destroy', $Journal->id)."' method='POST' style='display: inline-block;' onsubmit='return confirm('Etez -vous sur de cette Operation ?')'>
                    ".csrf_field()."
                    ".method_field('DELETE')."
                    
                    <button onclick='return confirm('Etez -vous sur de cette Operation ?') ><i class='fas fa-trash'></i>
                    </button>
                </form></td>
            </tr>";
           }
           elseif ($Journal->TypeMvt ==2) {
            $table.="<tr>
             <td>".$Journal->DateOperation."</td>
             <td>".$Journal->Piece."</td>
             <td></td>
             <td>".$Journal->NumeroCompte."</td>
             <td>".$Journal->Libelle."</td>
             <td>".number_format($Journal->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($Journal->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td> 
            <a href='".route('Journal.edit', $Journal->id)."'><i class='fas fa-edit'></i></a>
                         <form action='".route('Journal.destroy', $Journal->id)."' method='POST' style='display: inline-block;' onsubmit='return confirm('Etez -vous sur de cette Operation ?')'>
                    ".csrf_field()."
                    ".method_field('DELETE')."
                    
                    <button onclick='return confirm('Etez -vous sur de cette Operation ?') ><i class='fas fa-trash'></i>
                    </button>
                </form>
            </td>
            </tr>";
             }  
        }
        $tableListe = $table;
        $MD = number_format($MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise;
        $MC = number_format($MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise; 
        return view("Comptabilite/Journal.index", compact('Journal', 'Journals', 'MD', 'MC', 'tableListe', 'ComptePrincipals', 'CompteSubdivisionnaires'));
    }
  

      //Impression du Journal sur PDF

    public function JournalPdf(Request $request){
      $Compte_m="";
    if(isset($request->SubAcount) && !empty($request->SubAcount)){

        $Compte_mouv = CompteSubdivisionnaire::findOrFail($request->SubAcount);
        $Compte_m.=' SOUS COMPTE : '.$Compte_mouv->NumeroCompte.' / '.$Compte_mouv->Intitule;

    } elseif (isset($request->Acount) && !empty($request->Acount)) {

        $Compte_mouv = ComptePrincipal::findOrFail($request->Acount);
        $Compte_m.=' COMPTE : '.$Compte_mouv->NumeroCompte.' / '.$Compte_mouv->Intitule;

    } elseif (isset($request->Journal) && !empty($request->Journal)) {

        $Compte_mouv = CodeJournaux::findOrFail($request->Journal);
        $Compte_m.=' JOURNAL : '.$Compte_mouv->Code.' / '.$Compte_mouv->Journal;

    }else{
      $Compte_m.='JOURNAL GENERAL : tous les comptes';
    }

    $Exe = ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));
    
    //Cas de L'impression selon un trie /Debut
      if (isset($request->Rapport)) 
      {  
        //Trie selon le sous compte et la date /Debut
         if (isset($request->SubAcount) && !empty($request->SubAcount) && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)) {
           $Debut = $request->Debut;
           $Fin = $request->Fin;

           //Requetes qui recupere Tous les mouvemnts du comptes au cours de l'annee precise. 
             $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id') 
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->where('compte_subdivisionnaires.id', $request->SubAcount)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();

            //Requetes qui recupere la somme de debit des  mouvemnts du comptes au cours de l'annee precise.
              $MD =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_subdivisionnaires.id', $request->SubAcount)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MD');

            //Requetes qui recupere la somme de credit des  mouvemnts du comptes au cours de l'annee precise.
              $MC = DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_subdivisionnaires.id', $request->SubAcount)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MC');
         //Trie selon le sous compte et la date /Fin    
         }

         //Trie selon le compte et la date /Debut
         elseif(isset($request->Acount) && !empty($request->Acount) && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)){

           $Debut = $request->Debut;
           $Fin = $request->Fin;

           //Requetes qui recupere Tous les mouvemnts du comptes au cours de l'annee precise.
             $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->where('compte_principals.id', $request->Acount)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();
            
            //Requetes qui recupere la somme de debit des  mouvemnts du compte au cours de l'annee precise.
              $MD =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_principals.id', $request->Acount)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MD');
            
            //Requetes qui recupere la somme de credit des  mouvemnts du compte au cours de l'annee precise.
              $MC = DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_principals.id', $request->Acount)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MC');

          //Trie selon le compte et la date /Finn       
         }
         //Trie selon le Journal et la date /Debut
         elseif(isset($request->Journal) && !empty($request->Journal) && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)){

           $Debut = $request->Debut;
           $Fin = $request->Fin;

           //Requetes qui recupere Tous les mouvemnts du comptes au cours de l'annee precise.
             $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->join('compte_journals', 'compte_journals.Compte', '=', 'compte_principals.id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'compte_journals.Journal')
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->where('code_journauxes.id', $request->Journal)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();
            
            //Requetes qui recupere la somme de debit des  mouvemnts du compte au cours de l'annee precise.
              $MD =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->join('compte_journals', 'compte_journals.Compte', '=', 'compte_principals.id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'compte_journals.Journal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('code_journauxes.id', $request->Journal)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MD');
            
            //Requetes qui recupere la somme de credit des  mouvemnts du compte au cours de l'annee precise.
              $MC = DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->join('compte_journals', 'compte_journals.Compte', '=', 'compte_principals.id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'compte_journals.Journal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('code_journauxes.id', $request->Journal)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MC');

          //Trie selon le Journal et la date /Fin        
         }

          //Trie selon le Journal/Debut
         elseif(isset($request->Journal) && !empty($request->Journal)){

           $Debut = '';
           $Fin = '';

           //Requetes qui recupere Tous les mouvemnts du comptes au cours de l'annee precise.
             $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->join('compte_journals', 'compte_journals.Compte', '=', 'compte_principals.id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'compte_journals.Journal')
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->where('code_journauxes.id', $request->Journal)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();
            
            //Requetes qui recupere la somme de debit des  mouvemnts du compte au cours de l'annee precise.
              $MD =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->join('compte_journals', 'compte_journals.Compte', '=', 'compte_principals.id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'compte_journals.Journal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('code_journauxes.id', $request->Journal)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MD');
            
            //Requetes qui recupere la somme de credit des  mouvemnts du compte au cours de l'annee precise.
              $MC = DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->join('compte_journals', 'compte_journals.Compte', '=', 'compte_principals.id')
                  ->join('code_journauxes', 'code_journauxes.id', '=', 'compte_journals.Journal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('code_journauxes.id', $request->Journal)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MC');

          //Trie selon le Journal/Fin        
         }

         //Trie selon la date /Debut
         elseif(isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)){

           $Debut = $request->Debut;
           $Fin = $request->Fin;

           //Requetes qui recupere Tous les mouvemnts des  comptes au cours de l'annee precise.
             $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();

            //Requetes qui recupere la somme de debit des  mouvemnts des compte au cours de l'annee precise.
              $MD =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MD');
            
            //Requetes qui recupere la somme de debit des  mouvemnts des comptes au cours de l'annee precise.
              $MC = DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MC');

            //Trie selon la date /Fin
         }
        
        //Trie selon le compte /Debut
         elseif(isset($request->Acount) && !empty($request->Acount)){

           $Debut ="";
           $Fin = "";
             $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->where('compte_principals.id', $request->Acount)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();

              $MD =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_principals.id', $request->Acount)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MD');

              $MC = DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_principals.id', $request->Acount)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MC');

           //Trie selon le compte /Fin
         }

          //Trie selon le sous compte /Debut
         elseif (isset($request->SubAcount) && !empty($request->SubAcount)) {
           $Debut = "";
           $Fin = "";
             $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id') 
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->where('compte_subdivisionnaires.id', $request->SubAcount)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();

              $MD =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_subdivisionnaires.id', $request->SubAcount)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MD');

              $MC = DB::table('journals')
                  ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                  ->select(DB::raw('*')) 
                  ->where('journals.Etat', 0)
                  ->where('compte_subdivisionnaires.id', $request->SubAcount)
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->sum('MC');
         //Trie selon le compte /Fin
          }
          //Cas Trie /Fin
        } 
        //Debut Cas du Non tri
         else{
         $Journals =DB::table('journals')
                  ->join('compte_subdivisionnaires', 'journals.Compte', '=', 'compte_subdivisionnaires.id') 
                  ->select(DB::raw('journals.id, journals.DateOperation, journals.Ordre, journals.MD, journals.MC,compte_subdivisionnaires.NumeroCompte,compte_subdivisionnaires.Intitule,journals.TypeMvt,journals.Piece, journals.Libelle'))
                  ->where('journals.Exercice',session()->get('ExerciceComptableId'))
                  ->where('journals.Etat', 0)->get();
              
        $MD = Journal::whereEtatAndExercice(0,session()->get('ExerciceComptableId'))->sum('MD');
        $MC = Journal::whereEtatAndExercice(0,session()->get('ExerciceComptableId'))->sum('MC');

        // Fin cas non tri
      }
        $table ="";
        foreach ($Journals as $Journal) {
           if ($Journal->TypeMvt ==1) 
           { 
            $table.="
            <tr>
             <td>".$Journal->DateOperation."</td>
             <td>".$Journal->Ordre."</td>
             <td>".$Journal->NumeroCompte."</td>
             <td></td>
             <td>".$Journal->Intitule."</td>
             <td>".$Journal->Libelle."</td>
             <td>". number_format($Journal->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($Journal->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            </tr>";
           }
           elseif ($Journal->TypeMvt ==2) {
            $table.="<tr>
             <td>".$Journal->DateOperation."</td>
             <td>".$Journal->id."</td>
             <td></td>
             <td>".$Journal->NumeroCompte."</td>
             <td>".$Journal->Intitule."</td>
             <td>".$Journal->Libelle."</td>
             <td>".number_format($Journal->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($Journal->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            </tr>";
             }  
        }
        $tableListe = $table;
        $SOLDE = $MD-$MC;
        $MD = number_format($MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise;
        $MC = number_format($MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise;
        
        $SOLDE = number_format($SOLDE,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise;
        $pdf = PDF::loadView('Comptabilite/Journal.JournalPdf', compact('tableListe', 'MD', 'MC','Compte_m', 'Debut', 'Fin', 'SOLDE'))->setPaper('a2', 'Paysage');
         $fileName = 'Facture';
         return $pdf->stream($fileName . '.pdf');  
   }  
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(JournalRequest $request)
    {  
       if (Journal::UniqueFillfieldAcountNumber($request->CD,$request->CC) == true) {

        if (Journal::UniqueFillfieldAmount($request->MD,$request->MC) ==true) {
            if (Journal::matchingSetting($request->CD,$request->MD,$request->CC,$request->MC)) {


           if (isset($request->CD) AND !empty($request->CD)) {
               Journal::create([
            //'Ordre'=>$request->Ordre,
            'Compte'=>$request->CD,
            'TypeMvt'=>1,
            'DateOperation'=>$request->DateOperation,
            'Piece'=>$request->Piece,
            'MD'=>$request->MD,
            'MC'=>$request->MC,
            'Libelle'=>$request->Libelle,
            'Exercice'=>session()->get('ExerciceComptableId')
              ]);
           }else{
                
             Journal::create([
            //'Ordre'=>$request->Ordre,
            'Compte'=>$request->CC,
            'TypeMvt'=>2,
            'DateOperation'=>$request->DateOperation,
            'Piece'=>$request->Piece,
            'MD'=>$request->MD,
            'MC'=>$request->MC,
            'Libelle'=>$request->Libelle,
            'Exercice'=>session()->get('ExerciceComptableId')
              ]);
           }

            }else{
               session()->flash('messageDelete', 'Veuillez Respecter la correspondance des données!');
            }
        }else{
               session()->flash('messageDelete', 'Remplissez soit le Montant Debit soit le Montant Credit!');
            } 
        }else{
               session()->flash('messageDelete', 'Remplissez soit le Compte Debit soit le Compte Credit!');
            }

        return redirect(route('Journal.index')); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    { 
      $Journal = Journal::findOrFail($id);
      $CD = CompteSubdivisionnaire::findOrFail($Journal->Compte);
      return view("Comptabilite/Journal.edit", compact('Journal', 'CD'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(JournalRequest $request, $id)
    { 
       $Journal = Journal::findOrFail($id);
       if (Journal::UniqueFillfieldAcountNumber($request->CD,$request->CC) == true) {
        if (Journal::UniqueFillfieldAmount($request->MD,$request->MC) ==true) {
            if (Journal::matchingSetting($request->CD,$request->MD,$request->CC,$request->MC)) {

            if (isset($request->CD) AND !empty($request->CD)) {
               $Journal->update([
            //'Ordre'=>$request->Ordre,
            'Compte'=>$request->CD,
            'TypeMvt'=>1,
            'DateOperation'=>$request->DateOperation,
            'Piece'=>$request->Piece,
            'MD'=>$request->MD,
            'MC'=>$request->MC,
            'Libelle'=>$request->Libelle
            //'Exercice'=>session()->get('ExerciceComptableId')
              ]);
           }else{
                
             $Journal->update([
            //'Ordre'=>$request->Ordre,
            'Compte'=>$request->CC,
            'TypeMvt'=>2,
            'DateOperation'=>$request->DateOperation,
            'Piece'=>$request->Piece,
            'MD'=>$request->MD,
            'MC'=>$request->MC,
            'Libelle'=>$request->Libelle,
            //'Exercice'=>session()->get('ExerciceComptableId')
              ]);
           } 
           
            }else{
               session()->flash('messageDelete', 'Veuillez Respecter la correspondance des données!');
            }
        }else{
               session()->flash('messageDelete', 'Remplissez soit le Montant Debit soit le Montant Credit!');
            } 
        }else{
               session()->flash('messageDelete', 'Remplissez soit le Compte Debit soit le Compte Credit!');
            }

        return redirect(route('Journal.index')); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Journal::destroy($id);
         return redirect(route('Journal.index'));
    }


    //Affichage de tous les journaux
    public function PlanComptable()
    {
        $Comptes = ComptePrincipal::whereEtat(0)->get();
       
            $table="";

            foreach ($Comptes as $Compte) 
            { 
                
                $table.="<tr style='background-color:silver; font-weight:bold;'>
                  <td>".$Compte->NumeroCompte."</td>
                  <td>".$Compte->Intitule."</td>
                </tr>";
                $SComptes = CompteSubdivisionnaire::whereEtatAndComptepricipal(0,$Compte->id)->get();
                foreach ($SComptes as $SCompte) 
               {
                $table.="<tr style='background-color:white;'>
                  <td>".$SCompte->NumeroCompte."</td>
                  <td>".$SCompte->Intitule."</td>
                </tr>";
               }
            }

            
        $tableListe = $table;
        
        return view("Comptabilite/Journal.PlanComptable", compact("tableListe"));    
    }

    public function GrandLivre()
    {   
        $Comptes = ComptePrincipal::whereEtat(0)->get();
        $Types = Type::whereEtat(0)->get();
        $SComptes = CompteSubdivisionnaire::whereEtat(0)->get();
        return view("Comptabilite.GrandLivre", compact('SComptes', 'Comptes', 'Types'));
    }

    public function Balance()
    {
        $Comptes = ComptePrincipal::whereEtat(0)->get();
        $Types = Type::whereEtat(0)->get();
        $SComptes = CompteSubdivisionnaire::whereEtat(0)->get();
        return view("Comptabilite.Balance", compact('SComptes', 'Comptes', 'Types'));
    }

    public function research(Request $request){
        $Compte=$request->get('NumeroCompte');
        $SComptes=CompteSubdivisionnaire::where('NumeroCompte','like','%'.$Compte.'%')->where('Etat',0)->get();
        $AllSComptes="";
        foreach ($SComptes as $SCompte) {
            $AllSComptes.="<option value='".$SCompte->id."'>".$SCompte->NumeroCompte.'/'.$SCompte->Intitule."</option>";
        }
        echo $AllSComptes;
    }

        public function research1(Request $request){
        $Compte=$request->get('NumeroCompte');
        $SComptes=CompteSubdivisionnaire::where('NumeroCompte','like','%'.$Compte.'%')->where('Etat',0)->get();
        $AllSComptes="";
        foreach ($SComptes as $SCompte) {
            $AllSComptes.="<option value='".$SCompte->id."'>".$SCompte->NumeroCompte.'/'.$SCompte->Intitule."</option>";
        }
        echo $AllSComptes;
    }

    public function research2(Request $request){
        $Compte=$request->get('NumeroCompte');
        $SComptes=CompteSubdivisionnaire::where('NumeroCompte','like','%'.$Compte.'%')->where('Etat',0)->get();
        $AllSComptes="";
        foreach ($SComptes as $SCompte) {
            $AllSComptes.="<option value='".$SCompte->id."'>".$SCompte->NumeroCompte.'/'.$SCompte->Intitule."</option>";
        }
        echo $AllSComptes;
    }

    public function research3(Request $request){
        $Compte=$request->get('NumeroCompte');
        $SComptes=ComptePrincipal::where('NumeroCompte','like','%'.$Compte.'%')->where('Etat',0)->get();
        $AllSComptes="";
        foreach ($SComptes as $SCompte) {
            $AllSComptes.="<option value='".$SCompte->id."'>".$SCompte->NumeroCompte.'/'.$SCompte->Intitule."</option>";
        }
        echo $AllSComptes;
    }

     public function research4(Request $request){
        $Journal=$request->get('Journal');
        $Journals=CodeJournaux::where('Code','like','%'.$Journal.'%')->where('Etat',0)->get();
        $AllJournals="";
        foreach ($Journals as $Journal) {
            $AllJournals.="<option value='".$Journal->id."'>".$Journal->Code.'/'.$Journal->Journal."</option>";
        }
        echo $AllJournals;
    }


    //Function for generating Grand Livre According to user Request
    public function AfficherGdLivre(Request $request){
      if ($request->TypeCompte=="Tous") {
          $ClasseCompte = "Toutes les classes";
      }else{
          $ClasseCompte = Type::whereId($request->TypeCompte)->first();
          $ClasseCompte = $ClasseCompte->Types;
      }
      $Exe =ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));
      //Displaying the result on the screen
      if (isset($request->Afficher)) {
   //For requesting all the Account
        if (isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte=="Tous"  && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)) {
             $Debut = $request->Debut;
             $Fin = $request->Fin;
    
             $SComptes = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->select(DB::raw('compte_principals.id, compte_principals.NumeroCompte, compte_principals.Intitule'))
                ->GroupBy('compte_principals.id')
                ->get();

            }elseif(isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte!="Tous"){
                 $SComptes = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->select(DB::raw('compte_principals.id, compte_principals.NumeroCompte, compte_principals.Intitule'))
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->GroupBy('compte_principals.id')
                ->get();
            }
            $table="";
           
            foreach ($SComptes as $SCompte) {
            
               $table.="
                  <tbody>
                <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                  <td colspan='4'>".'Compte '.$SCompte->NumeroCompte.' '.$SCompte->Intitule."</td>
                </tr>";
          if (isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte=="Tous"  && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)) {
              $GrandLivres = DB::table('types')
              ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
              ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->get();
                
            
                $SMD = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->sum('MD');
               

                $SMC = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->sum('MC');

                $SMDT = Journal::whereEtat(0)->whereBetween('journals.DateOperation',[$Debut, $Fin])->sum('MD');
                $SMCT = Journal::whereEtat(0)->whereBetween('journals.DateOperation',[$Debut, $Fin])->sum('MC');
              }
              elseif(isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte!="Tous"  && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)) 
              {
                $Debut=$request->Debut;
                $Fin=$request->Fin;
                $GrandLivres = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->get();

               $SMD = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                 ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
               ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MD');

                
              $SMC = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                 ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
               ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MC');

                $SMDT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('journals.Etat', 0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MD');

                $SMCT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('journals.Etat', 0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MC');
              }  
              $SOLDE =  $SMD- $SMC;
            foreach ($GrandLivres as $GrandLivre) {   

                if ($GrandLivre->TypeMvt==1) {
                     $table.="
                <tr style='background-color:white;'>
                  <td>".$GrandLivre->DateOperation."</td>
                  <td>".$GrandLivre->Intitule."</td>
                  <td>".number_format($GrandLivre->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                  <td></td>
                </tr>";
                }elseif ($GrandLivre->TypeMvt==2) {
                     $table.="
                     <tbody> 
                <tr style='background-color:white;'>
                  <td>".$GrandLivre->DateOperation."</td>
                  <td>".$GrandLivre->Intitule."</td>
                  <td></td>
                  <td>".number_format($GrandLivre->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                </tr>";
                }
              }
             if ($SOLDE < 0) {
              $SOLDE*=-1;
                  $table.=
              "
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'TOTAL'."</td><td>".number_format($SMD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'SOLDE'."</td><td>".'0'."</td><td>".number_format($SOLDE,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
              ";
              }elseif($SOLDE > 0){
                  $table.=
              "
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'TOTAL'."</td><td>".number_format($SMD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'SOLDE'."</td><td>".number_format($SOLDE,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".'0'."</td></tr>
              ";
              }else{
                  $table.=
              "
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'TOTAL'."</td><td>".number_format($SMD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'SOLDE'."</td><td>".'0'."</td><td>".'0'."</td></tr>
              ";
              }
            }
            $table.="

               <tr style='font-weight: bold;background-color:white; text-align:center;'><td colspan='2'>".'TOTAL GRAND LIVRE'."</td><td>".number_format($SMDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>

            ";
            $tableListe = $table;
            return view("Comptabilite.AfficherGdLivre", compact('tableListe','ClasseCompte', 'Debut', 'Fin'));
      }
      //Print the result on PDF file
      else{
          //For requesting all the Account
        if (isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte=="Tous"  && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)) {
             $Debut = $request->Debut;
             $Fin = $request->Fin;
    
             $SComptes = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->select(DB::raw('compte_principals.id, compte_principals.NumeroCompte, compte_principals.Intitule'))
                ->GroupBy('compte_principals.id')
                ->get();

            }elseif(isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte!="Tous"){
                 $SComptes = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->select(DB::raw('compte_principals.id, compte_principals.NumeroCompte, compte_principals.Intitule'))
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->GroupBy('compte_principals.id')
                ->get();
            }
            $table="";
           
            foreach ($SComptes as $SCompte) {
            
               $table.="
                  <tbody>
                <tr style='text-align:center;font-weight:bold;background-color:silver;'>
                  <td colspan='4'>".'Compte '.$SCompte->NumeroCompte.' '.$SCompte->Intitule."</td>
                </tr>";
          if (isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte=="Tous"  && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)) {
              $GrandLivres = DB::table('types')
              ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
              ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->get();
                
            
                $SMD = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->sum('MD');
               

                $SMC = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->sum('MC');

                $SMDT = Journal::whereEtat(0)->whereBetween('journals.DateOperation',[$Debut, $Fin])->sum('MD');
                $SMCT = Journal::whereEtat(0)->whereBetween('journals.DateOperation',[$Debut, $Fin])->sum('MC');
              }
              elseif(isset($request->TypeCompte) AND !empty($request->TypeCompte) AND $request->TypeCompte!="Tous"  && isset($request->Debut) && !empty($request->Debut) && isset($request->Fin) && !empty($request->Fin)) 
              {
                $Debut=$request->Debut;
                $Fin=$request->Fin;
                $GrandLivres = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->get();

               $SMD = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                 ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
               ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MD');

                
              $SMC = DB::table('journals')
                 ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.id', '=', 'journals.Compte')
                 ->join('compte_principals', 'compte_principals.id', '=', 'compte_subdivisionnaires.ComptePricipal')
                ->select(DB::raw(''))
                ->where('journals.Etat', 0)
               ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.ComptePricipal', $SCompte->id)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MC');

                $SMDT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('journals.Etat', 0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MD');

                $SMCT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('journals.DateOperation, journals.MD, journals.MC, compte_subdivisionnaires.Intitule,journals.TypeMvt,compte_subdivisionnaires.id'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('journals.Etat', 0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MC');
              }  
              $SOLDE =  $SMD- $SMC;
            foreach ($GrandLivres as $GrandLivre) {   

                if ($GrandLivre->TypeMvt==1) {
                     $table.="
                <tr style='background-color:white;'>
                  <td>".$GrandLivre->DateOperation."</td>
                  <td>".$GrandLivre->Intitule."</td>
                  <td>".number_format($GrandLivre->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                  <td></td>
                </tr>";
                }elseif ($GrandLivre->TypeMvt==2) {
                     $table.="
                     <tbody> 
                <tr style='background-color:white;'>
                  <td>".$GrandLivre->DateOperation."</td>
                  <td>".$GrandLivre->Intitule."</td>
                  <td></td>
                  <td>".number_format($GrandLivre->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                </tr>";
                }
              }
             if ($SOLDE < 0) {
              $SOLDE*=-1;
                  $table.=
              "
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'TOTAL'."</td><td>".number_format($SMD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'SOLDE'."</td><td>".'0'."</td><td>".number_format($SOLDE,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
              ";
              }elseif($SOLDE > 0){
                  $table.=
              "
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'TOTAL'."</td><td>".number_format($SMD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'SOLDE'."</td><td>".number_format($SOLDE,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".'0'."</td></tr>
              ";
              }else{
                  $table.=
              "
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'TOTAL'."</td><td>".number_format($SMD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>
               <tr style='font-weight: bold;background-color:white;'><td>".'DATE'."</td><td>".'SOLDE'."</td><td>".'0'."</td><td>".'0'."</td></tr>
              ";
              }
            }
            $table.="

               <tr style='font-weight: bold;background-color:white; text-align:center;'><td colspan='2'>".'TOTAL GRAND LIVRE'."</td><td>".number_format($SMDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td><td>".number_format($SMCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>

            ";
            $tableListe = $table;
            $pdf = PDF::loadView('Comptabilite.GrandLivrePdf', compact('tableListe', 'MD', 'MC','ClasseCompte', 'Debut', 'Fin'))->setPaper('a3', 'Paysage');
            $fileName = 'Facture';
             return $pdf->stream($fileName . '.pdf');
      }  
        
    }

    public function AfficherBalance(Request $request){
      $Exe = ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));

      if ($request->TypeCompte=="Tous") {
          $ClasseCompte = "Toutes les classes";
      }else{
          $ClasseCompte = Type::whereId($request->TypeCompte)->first();
          $ClasseCompte = $ClasseCompte->Types;
      }
      //Displying on the screen
      if (isset($request->Afficher)) {

        if (isset($request->TypeCompte) AND !empty($request->TypeCompte) && $request->TypeCompte=="Tous" && isset($request->Debut) AND !empty($request->Debut) && isset($request->Fin) AND !empty($request->Fin)) {
       $Debut=$request->Debut;
       $Fin = $request->Fin;

    $SComptes = DB::table('compte_principals')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=','compte_principals.id')
                ->leftJoin('compte_report_comptes', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->leftJoin('repportages', 'compte_report_comptes.id','=', 'repportages.compte_id')
                ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('compte_principals.NumeroCompte, compte_principals.Intitule, sum(journals.MD) as MD, sum(journals.MC) as MC,repportages.montant'))
                ->where('compte_subdivisionnaires.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->GroupBy('compte_principals.NumeroCompte')
                ->get();
    $MDT = DB::table('compte_subdivisionnaires')
                  ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.Etat', 0)
                ->sum('MD');

    $MCT = DB::table('compte_subdivisionnaires')
                  ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.Etat', 0)
                ->sum('MC');

   $MRPD = DB::table('repportages')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '>',0)
                ->sum('montant');

    $MRPC = DB::table('repportages')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '<',0)
                ->sum('montant');                 

  }
  elseif(isset($request->TypeCompte) AND !empty($request->TypeCompte) && $request->TypeCompte!="Tous" && isset($request->Debut) AND !empty($request->Debut) && isset($request->Fin) AND !empty($request->Fin)){
     $Debut=$request->Debut; 
     $Fin = $request->Fin;

    $SComptes = DB::table('compte_principals')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=','compte_principals.id')
                ->leftJoin('compte_report_comptes', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->leftJoin('repportages', 'compte_report_comptes.id','=', 'repportages.compte_id')
                ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('compte_principals.NumeroCompte, compte_principals.Intitule, sum(journals.MD) as MD, sum(journals.MC) as MC,repportages.montant'))
                ->where('compte_subdivisionnaires.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->GroupBy('compte_principals.NumeroCompte')
                ->get();

    $MDT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->where('compte_subdivisionnaires.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MD');

    $MCT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->where('compte_subdivisionnaires.Etat', 0)
                 ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MC'); 

    $MRPD = DB::table('repportages')
                ->join('compte_report_comptes', 'repportages.compte_id', '=', 'compte_report_comptes.id')
                ->join('compte_principals', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '>',0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('montant');

    $MRPC = DB::table('repportages')
                ->join('compte_report_comptes', 'repportages.compte_id', '=', 'compte_report_comptes.id')
                ->join('compte_principals', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '<',0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('montant');                                          
          }
             $table=""; 
             $SD=0;
             $SC=0;  
             foreach ($SComptes as $SCompte) 
             { 

                $Diff = ($SCompte->MD-$SCompte->MC)+$SCompte->montant;
            
                if ($Diff >0) {
                  $SD+=$Diff;
                  if($SCompte->montant>0){
                   
                     $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                     <td></td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";

                  }else{
                      $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                   <td></td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";
                  }
                    
                   
                }elseif($Diff <0){
                  //$Diff*=-1;
                  $SC+=$Diff;

                  if($SCompte->montant>0){
                     $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                     <td></td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   
                 </tr>";
                  }else{
                  $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                   <td></td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   
                 </tr>";
                  }
                    
                }else{
                   if($SCompte->montant>0){
                     $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                     <td></td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";
                  }else{
                  $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                   <td></td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";
                }
             }
           }  
             $Diff = $MDT-$MCT;
             if ($Diff>0) {
                $table.="
               <tr style='background-color:silver;font-weight:bold;text-align:center;'>
                   <td colspan='2'>TOTAL</td>
                    <td>".number_format($MRPD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MRPC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>

                   <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                    <td>".number_format($SD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
               </tr>"; 
             }elseif($Diff<0){
              $Diff*=-1;
                 $table.="
               <tr style='background-color:silver;font-weight:bold;text-align:center;'>
                   <td colspan='2'>TOTAL</td>
                   <td>".number_format($MRPD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MRPC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                    <td>".number_format($SD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
               </tr>"; 
             }else{
                $table.="
               <tr style='background-color:silver;font-weight:bold;text-align:center;'>
                   <td colspan='2'>TOTAL</td>
                   <td>".number_format($MRPD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MRPC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                    <td>".number_format($SD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
               </tr>"; 
             }
       $tableListe = $table;
       return view("Comptabilite.AfficherBalance", compact('tableListe', 'ClasseCompte', 'Debut', 'Fin'));
      }else{
         
     if (isset($request->TypeCompte) AND !empty($request->TypeCompte) && $request->TypeCompte=="Tous" && isset($request->Debut) AND !empty($request->Debut) && isset($request->Fin) AND !empty($request->Fin)) {
       $Debut=$request->Debut;
       $Fin = $request->Fin;

    $SComptes = DB::table('compte_principals')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=','compte_principals.id')
                ->leftJoin('compte_report_comptes', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->leftJoin('repportages', 'compte_report_comptes.id','=', 'repportages.compte_id')
                ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('compte_principals.NumeroCompte, compte_principals.Intitule, sum(journals.MD) as MD, sum(journals.MC) as MC,repportages.montant'))
                ->where('compte_subdivisionnaires.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->GroupBy('compte_principals.NumeroCompte')
                ->get();
    $MDT = DB::table('compte_subdivisionnaires')
                  ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.Etat', 0)
                ->sum('MD');

    $MCT = DB::table('compte_subdivisionnaires')
                  ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_subdivisionnaires.Etat', 0)
                ->sum('MC');

   $MRPD = DB::table('repportages')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '>',0)
                ->sum('montant');

    $MRPC = DB::table('repportages')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '<',0)
                ->sum('montant');                 

  }
  elseif(isset($request->TypeCompte) AND !empty($request->TypeCompte) && $request->TypeCompte!="Tous" && isset($request->Debut) AND !empty($request->Debut) && isset($request->Fin) AND !empty($request->Fin)){
     $Debut=$request->Debut; 
     $Fin = $request->Fin;

    $SComptes = DB::table('compte_principals')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=','compte_principals.id')
                ->leftJoin('compte_report_comptes', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->leftJoin('repportages', 'compte_report_comptes.id','=', 'repportages.compte_id')
                ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('compte_principals.NumeroCompte, compte_principals.Intitule, sum(journals.MD) as MD, sum(journals.MC) as MC,repportages.montant'))
                ->where('compte_subdivisionnaires.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->GroupBy('compte_principals.NumeroCompte')
                ->get();

    $MDT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->where('compte_subdivisionnaires.Etat', 0)
                ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MD');

    $MCT = DB::table('types')
                ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
                ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
                ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
                ->select(DB::raw('*'))
                ->where('compte_subdivisionnaires.Etat', 0)
                 ->whereBetween('journals.DateOperation',[$Debut, $Fin])
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('MC'); 

    $MRPD = DB::table('repportages')
                ->join('compte_report_comptes', 'repportages.compte_id', '=', 'compte_report_comptes.id')
                ->join('compte_principals', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '>',0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('montant');

    $MRPC = DB::table('repportages')
                ->join('compte_report_comptes', 'repportages.compte_id', '=', 'compte_report_comptes.id')
                ->join('compte_principals', 'compte_principals.id', '=', 'compte_report_comptes.compte_principale_id')
                ->select(DB::raw('*'))
                ->where('repportages.reported_in',session()->get('ExerciceComptableId'))
                ->where('repportages.montant', '<',0)
                ->where('compte_principals.TypeCompte', $request->TypeCompte)
                ->sum('montant');                                          
          }
             $table=""; 
             $SD=0;
             $SC=0;  
             foreach ($SComptes as $SCompte) 
             { 

                $Diff = ($SCompte->MD-$SCompte->MC)+$SCompte->montant;
            
                if ($Diff >0) {
                  $SD+=$Diff;
                  if($SCompte->montant>0){
                   
                     $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                     <td></td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";

                  }else{
                      $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                   <td></td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";
                  }
                    
                   
                }elseif($Diff <0){
                  //$Diff*=-1;
                  $SC+=$Diff;

                  if($SCompte->montant>0){
                     $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                     <td></td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   
                 </tr>";
                  }else{
                  $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                   <td></td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   
                 </tr>";
                  }
                    
                }else{
                   if($SCompte->montant>0){
                     $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                     <td></td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";
                  }else{
                  $table.="<tr style='background-color:white;text-align:center;'>
                   <td>".$SCompte->NumeroCompte."</td>
                   <td>".$SCompte->Intitule."</td>
                   <td></td>
                    <td>".number_format($SCompte->montant,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SCompte->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td></td>
                 </tr>";
                }
             }
           }  
             $Diff = $MDT-$MCT;
             if ($Diff>0) {
                $table.="
               <tr style='background-color:silver;font-weight:bold;text-align:center;'>
                   <td colspan='2'>TOTAL</td>
                    <td>".number_format($MRPD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MRPC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>

                   <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                    <td>".number_format($SD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
               </tr>"; 
             }elseif($Diff<0){
              $Diff*=-1;
                 $table.="
               <tr style='background-color:silver;font-weight:bold;text-align:center;'>
                   <td colspan='2'>TOTAL</td>
                   <td>".number_format($MRPD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MRPC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                    <td>".number_format($SD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
               </tr>"; 
             }else{
                $table.="
               <tr style='background-color:silver;font-weight:bold;text-align:center;'>
                   <td colspan='2'>TOTAL</td>
                   <td>".number_format($MRPD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MRPC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                    <td>".number_format($SD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                   <td>".number_format($SC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
               </tr>"; 
             }
       $tableListe = $table;
       $pdf = PDF::loadView('Comptabilite.BalancePdf', compact('tableListe','ClasseCompte', 'Debut', 'Fin'))->setPaper('a3', 'Paysage');
            $fileName = 'Facture';
        return $pdf->stream($fileName . '.pdf');
      }

    }

    public function CompteResultat(){
      $Exe = ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));
        $ComptesResultats = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->leftJoin('exercice_comptables', 'exercice_comptables.id', '=', 'journals.Exercice')
            ->select(DB::raw(' sum(journals.MD) as MD, sum(journals.MC) as MC, compte_principals.Intitule, compte_principals.NumeroCompte'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->GroupBy('compte_principals.NumeroCompte')
            ->get();

    $MDT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', session()->get('ExerciceComptableId'))
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->sum('MD');  

    $MCT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', session()->get('ExerciceComptableId'))
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->sum('MC');                  
    $Diff = $MDT-$MCT;
        $table="";
        
        foreach ($ComptesResultats as $ComptesResultat) {
            $table.="<tr style='background-color:white;'>
              <td>".$ComptesResultat->NumeroCompte."</td>
              <td>".$ComptesResultat->Intitule."</td>
              <td>".number_format($ComptesResultat->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
              <td>".number_format($ComptesResultat->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            </tr>";
        }


      if ($Diff > 0) {
        $MCT+=$Diff;
          $table.="
        <tr style='background-color:silver; font-weight:bold;'>
          <td></td>
          <td>".'Résultat : Bénéfice'."</td>
           <td></td>
            <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>

        <tr style='background-color:silver; font-weight:bold;'>
          <td colspan='2'>".'TOTAL'."</td>
           <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>";
      }elseif($Diff<0){
        $MDT+=$Diff;
        $table.="
        <tr style='background-color:silver; font-weight:bold;'>
          <td></td>
          <td>".'Résultat : Bénéfice'."</td>
           <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td></td>
        </tr>

        <tr style='background-color:silver; font-weight:bold;'>
          <td colspan='2'>".'TOTAL'."</td>
           <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>";
      }else{
        $table.="
        <tr style='background-color:silver; font-weight:bold;'>
          <td></td>
          <td>".'Résultat : Bénéfice'."</td>
           <td>".'0'."</td>
            <td>".'0'."</td>
        </tr>

        <tr style='background-color:silver; font-weight:bold;'>
          <td colspan='2'>".'TOTAL'."</td>
           <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>";
      }
        
        $tableListe = $table; 
        return view("Comptabilite.CompteResultat", compact('tableListe'));   
    }

       public function ResultatPdf(Request $request){
        $Exe = ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));
        if (isset($request->Rapport) && !empty($request->Debut) && isset($request->Debut) && !empty($request->Fin) && isset($request->Fin)) {
          $Debut=$request->Debut;
          $Fin=$request->Fin;
             $ComptesResultats = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->leftJoin('exercice_comptables', 'exercice_comptables.id', '=', 'journals.Exercice')
            ->select(DB::raw(' sum(journals.MD) as MD, sum(journals.MC) as MC, compte_principals.Intitule, compte_principals.NumeroCompte'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->whereBetween('journals.DateOperation',[$Debut, $Fin])
            ->GroupBy('compte_principals.NumeroCompte')
            ->get();

    $MDT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            //->where('journals.Exercice', session()->get('ExerciceComptableId'))
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->whereBetween('journals.DateOperation',[$Debut, $Fin])
            ->sum('MD');  

    $MCT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', session()->get('ExerciceComptableId'))
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->whereBetween('journals.DateOperation',[$Debut, $Fin])
            ->sum('MC');                  
        }else{

            $ComptesResultats = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw(' sum(journals.MD) as MD, sum(journals.MC) as MC, compte_principals.Intitule, compte_principals.NumeroCompte'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->GroupBy('compte_principals.NumeroCompte')
            ->get();

    $MDT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', session()->get('ExerciceComptableId'))
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->sum('MD');  

    $MCT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', session()->get('ExerciceComptableId'))
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->sum('MC');                  
        }
       
    $Diff = $MDT-$MCT;
        $table="";
        
        foreach ($ComptesResultats as $ComptesResultat) {
            $table.="<tr style='background-color:white;'>
              <td>".$ComptesResultat->NumeroCompte."</td>
              <td>".$ComptesResultat->Intitule."</td>
              <td>".number_format($ComptesResultat->MD,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
              <td>".number_format($ComptesResultat->MC,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            </tr>";
        }


      if ($Diff > 0) {
        $MCT+=$Diff;
          $table.="
        <tr style='background-color:silver; font-weight:bold;'>
          <td></td>
          <td>".'Résultat : Bénéfice'."</td>
           <td></td>
            <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>

        <tr style='background-color:silver; font-weight:bold;'>
          <td colspan='2'>".'TOTAL'."</td>
           <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>";
      }elseif($Diff<0){
        $MDT+=$Diff;
        $table.="
        <tr style='background-color:silver; font-weight:bold;'>
          <td></td>
          <td>".'Résultat : Bénéfice'."</td>
           <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td></td>
        </tr>

        <tr style='background-color:silver; font-weight:bold;'>
          <td colspan='2'>".'TOTAL'."</td>
           <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>";
      }else{
        $table.="
        <tr style='background-color:silver; font-weight:bold;'>
          <td></td>
          <td>".'Résultat : Bénéfice'."</td>
           <td>".'0'."</td>
            <td>".'0'."</td>
        </tr>

        <tr style='background-color:silver; font-weight:bold;'>
          <td colspan='2'>".'TOTAL'."</td>
           <td>".number_format($MDT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
            <td>".number_format($MCT,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
        </tr>";
      }
        
        $tableListe = $table; 
        $pdf = PDF::loadView('Comptabilite.ResultatPdf', compact('tableListe','Debut', 'Fin'))->setPaper('a3', 'Paysage');
            $fileName = 'Facture';
        return $pdf->stream($fileName . '.pdf');  
    }

    public function Bilan(){
        
        $Exe = ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));
        $Exercices = ExerciceComptable::whereEtat(0)->get();
         $ComptesActifBilans = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw(' sum(journals.MD) as MD, sum(journals.MC) as MC, compte_principals.Intitule, compte_principals.NumeroCompte, compte_principals.Categorie'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('compte_principals.Categorie', "Actif")
            ->GroupBy('compte_principals.id')
            ->get();


        $ComptesPassifBilans = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw(' sum(journals.MD) as MD, sum(journals.MC) as MC, compte_principals.Intitule, compte_principals.NumeroCompte, compte_principals.Categorie'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('compte_principals.Categorie', "Passif")
            ->GroupBy('compte_principals.id')
            ->get(); 

            //Resultat de L'exercice
      $MDT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->sum('MD');  

    $MCT = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('types.Class', 6)->Orwhere('types.Class', 7)
            ->sum('MC');                  
    $Resultat = $MDT-$MCT;


         $table1="<tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder' colspan='2'>ACTIF</th></tr>";
         $table2="<tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder' colspan='2'>PASSIF</th></tr>";
         $TActif=0;
         $TPassif=0;

         //Boucle Pour les comptes d'Actifs
         foreach ($ComptesActifBilans as $ComptesActifBilan) {
                $Diff = $ComptesActifBilan->MD - $ComptesActifBilan->MC;
               //On rend la difference positive si elle negative
               if ($Diff<0) {
                   $Diff*=-1;
                } else{
                    $Diff*=1;
                }
                 $TActif+=$Diff;
                     $table1.="<tr style='background-color:white;'>
                <td>".$ComptesActifBilan->Intitule."</td>
                <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>";
            }
          
          //Boucle Pour les comptes de Passifs
         foreach ($ComptesPassifBilans as $ComptesPassifBilan) {
                $Diff = $ComptesPassifBilan->MD - $ComptesPassifBilan->MC;
               //On rend la difference positive si elle negative
               if ($Diff<0) {
                   $Diff*=-1;
                } else{
                    $Diff*=1;
                }

                $TPassif+=$Diff;
                     $table2.="<tr style='background-color:white;'>
                <td>".$ComptesPassifBilan->Intitule."</td>
                <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                </tr>";
    
            } 
            $TPassif+= $Resultat; 
            $table1.="<tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder'>TOTAL ACTIF</th> <th style='font-weight:bolder'>".number_format($TActif,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</th></tr>";

            $table2.="
            <tr style='background-color:white;font-weight:bolder'><th style='font-weight:bolder'>Résultat</th> <th style='font-weight:bolder'>".number_format($Resultat,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</th></tr>

            <tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder'>TOTAL PASSIF</th> <th style='font-weight:bolder'>".number_format($TPassif,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</th></tr>";
            $tableListe = $table1.$table2; 
        return view("Comptabilite.Bilan", compact('tableListe', 'Exercices'));    
    }

    public function BilanPdf(Request $request)
    {   
        $ExerciceComptab = ExerciceComptable::findOrFail($request->Exercice);
        $Exe = ExerciceComptable::findOrFail(session()->get('ExerciceComptableId'));
        $Exercices = ExerciceComptable::whereEtat(0)->get();
         $ComptesActifBilans = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->leftJoin('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw(' sum(journals.MD) as MD, sum(journals.MC) as MC, compte_principals.Intitule, compte_principals.NumeroCompte, compte_principals.Categorie'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', $request->Exercice)
            ->where('compte_principals.Categorie', "Actif")
            ->GroupBy('compte_principals.id')
            ->get();

            
            //Resultat de L'exercice
      $MDT6 = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', $request->Exercice)
            ->where('types.Class', 6)
            ->sum('MD');  

    $MCT6 = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', $request->Exercice)
            ->where('types.Class', 6)
            ->sum('MC');   

    $MDT7 = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', $request->Exercice)
            ->where('types.Class', 7)
            ->sum('MD');  

    $MCT7 = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->join('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw('*'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', $request->Exercice)
            ->where('types.Class', 7)
            ->sum('MC');  
      $MDT = $MDT6+$MDT7; 
      $MCT = $MCT6+$MCT7;                                    
    $Resultat = $MDT-$MCT;



        $ComptesPassifBilans = DB::table('types')
            ->join('compte_principals', 'compte_principals.TypeCompte', '=', 'types.id')
            ->join('compte_subdivisionnaires', 'compte_subdivisionnaires.ComptePricipal', '=', 'compte_principals.id')
            ->leftJoin('journals', 'journals.Compte', '=', 'compte_subdivisionnaires.id')
            ->select(DB::raw(' sum(journals.MD) as MD, sum(journals.MC) as MC, compte_principals.Intitule, compte_principals.NumeroCompte, compte_principals.Categorie'))
            ->where('compte_subdivisionnaires.Etat', 0)
            ->where('compte_principals.Etat', 0)
            ->where('journals.Exercice', $request->Exercice)
            ->where('compte_principals.Categorie', "Passif")
            ->GroupBy('compte_principals.id')
            ->get();    
            
         $table1="<tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder' colspan='2'>ACTIF</th></tr>";
         $table2="<tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder' colspan='2'>PASSIF</th></tr>";
         $TActif=0;
         $TPassif=0;
         foreach ($ComptesActifBilans as $ComptesActifBilan) {
                $Diff = $ComptesActifBilan->MD - $ComptesActifBilan->MC;
               //On rend la difference positive si elle negative
               if ($Diff<0) {
                   $Diff*=-1;
                } else{
                    $Diff*=1;
                }
                 $TActif+=$Diff;
                     $table1.="<tr style='background-color:white;'>
                <td>".$ComptesActifBilan->Intitule."</td>
                <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td></tr>";
            }

         foreach ($ComptesPassifBilans as $ComptesPassifBilan) {
                $Diff = $ComptesPassifBilan->MD - $ComptesPassifBilan->MC;
               //On rend la difference positive si elle negative
               if ($Diff<0) {
                   $Diff*=-1;
                } else{
                    $Diff*=1;
                }

                $TPassif+=$Diff;
                     $table2.="<tr style='background-color:white;'>
                <td>".$ComptesPassifBilan->Intitule."</td>
                <td>".number_format($Diff,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</td>
                </tr>";
    
            }  
            $TPassif+= $Resultat;  
            $table1.="<tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder'>TOTAL ACTIF</th> <th style='font-weight:bolder'>".number_format($TActif,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</th></tr>";

            $table2.="
             <tr style='background-color:white;font-weight:bolder'><th style='font-weight:bolder'>Résultat</th> <th style='font-weight:bolder'>".number_format($Resultat,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</th></tr>

            <tr style='background-color:silver;text-align:center;font-weight:bolder'><th style='font-weight:bolder'>TOTAL PASSIF</th> <th style='font-weight:bolder'>".number_format($TPassif,$Exe->NbreDecimal,$Exe->separateurDecimal,$Exe->separateurMilieu).' '.$Exe->Devise."</th></tr>";
            $tableListe = $table1.$table2; 
        $pdf = PDF::loadView('Comptabilite.BilanPdf', compact('tableListe', 'ExerciceComptab'))->setPaper('a3', 'Paysage');
            $fileName = 'Facture';
        return $pdf->stream($fileName . '.pdf');

    }  
}       

