<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\ReportageFormRequest;
use App\Http\Requests;
use\App\Models\Repportage;
use DB;
class RepportageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ReportageFormRequest $request)
    {   
        if ($request->Montant>0) {
            
            $Compte =DB::table('compte_report_comptes')
                    ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                    ->select(DB::raw('compte_report_comptes.id'))
                    ->where('compte_repports.Type_compte', 'Debiteur')
                    ->where('compte_report_comptes.compte_principale_id',$request->Compte)
                    ->first();
        }else if($request->Montant<0){
           $Compte =DB::table('compte_report_comptes')
                ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                ->select(DB::raw('compte_report_comptes.id'))
                ->where('compte_repports.Type_compte', 'Crediteur')
                ->where('compte_report_comptes.compte_principale_id',$request->Compte)
                ->first();
        }
        
      if($request->Montant!=0){
          Repportage::create([
            'compte_id'=>$Compte->id,
            'montant'=>$request->Montant,
            'exercice_id'=>session()->get('ExerciceComptableId'),
            'reported_in'=>session()->get('ExerciceComptableId')
        ]);
      }else{
        session()->flash('messageDelete', 'Le Montant à repporter ne peut pas etre égale à 0 !');
      }     
        return redirect(route('SaisieNouveauForm')); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Repportage = Repportage::findOrFail($id);
        $Saisies = DB::table('compte_principals')
                ->join('compte_report_comptes', 'compte_report_comptes.compte_principale_id', '=', 'compte_principals.id')
                ->join('repportages', 'repportages.compte_id', '=', 'compte_report_comptes.id')
                ->select(DB::raw('repportages.id, compte_principals.NumeroCompte,repportages.montant'))
                ->get();

        return view('Comptabilite/CompteRepport.SaisieNouveauFormEdit', compact('Saisies', 'Repportage'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ReportageFormRequest $request, $id)
    {   
        $Repportage = Repportage::findOrFail($id);
         if ($request->Montant>0) {
            
            $Compte =DB::table('compte_report_comptes')
                    ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                    ->select(DB::raw('compte_report_comptes.id'))
                    ->where('compte_repports.Type_compte', 'Debiteur')
                    ->where('compte_report_comptes.compte_principale_id',$request->Compte)
                    ->first();
        }else if($request->Montant<0){
           $Compte =DB::table('compte_report_comptes')
                ->join('compte_repports', 'compte_repports.id', '=', 'compte_report_comptes.compte_repport_id')
                ->select(DB::raw('compte_report_comptes.id'))
                ->where('compte_repports.Type_compte', 'Crediteur')
                ->where('compte_report_comptes.compte_principale_id',$request->Compte)
                ->first();
        }
        
      if($request->Montant!=0){
          $Repportage->update([
            'compte_id'=>$Compte->id,
            'montant'=>$request->Montant,
            'exercice_id'=>session()->get('ExerciceComptableId'),
            'reported_in'=>session()->get('ExerciceComptableId')
        ]);
      }else{
        session()->flash('messageDelete', 'Le Montant à repporter ne peut pas etre égale à 0 !');
      }     
        return redirect(route('SaisieNouveauForm')); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $Repportage = Repportage::findOrFail($id);
         $Repportage->destroy($id);

         session()->flash('messageDelete', 'Suppression effectuée avec success !');
         return redirect(route('SaisieNouveauForm')); 
    }
}
