<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('/', function () {
    return view('welcome');
})->name('index');
//Route::post('/', 'ConnexionController@index')->name('index');
Route::post('/main/Verification', 'ConnexionController@Verification')->name('Verification');
Route::get('/Login', 'PartenaireController@Login')->name('Login');
Route::post('/main/VerifLogin', 'ConnexionController@VerifLogin')->name('VerifLogin');


Route::group(['middleware' => 'auth'], function(){

Route::get('CleanFile', 'OrigineController@cleanFile')->name('cleanFile');
Route::post('AttachAccount', 'PartenaireController@AttachAccount')->name('AttachAccount');
Route::delete('Deletemulite', 'AffilierController@Deletemulite')->name('Deletemulite');	

Route::get('/Categorize/{Servi}', 'medicamentsserviceController@Categorize')->name('Categorize');
Route::post('/DefCategorie/{id}', 'medicamentsserviceController@DefCategorie')->name('DefCategorie');

Route::get('/index', 'ComptabiliteController@index')->name('index');
Route::get('RattacherPartenaire/{medicament}', 'medicamentPartenaireController@Rattacher')->name('RattacherPartenaire');
Route::get('getProduiBenfic', 'FactureController@getProduiBenfic')->name('getProduiBenfic');

Route::get('/main/Deconnexion', 'ConnexionController@Deconnexion')->name('Deconnexion');

Route::resource('Affiliers', 'AffilierController');
Route::resource('Services', 'ServiceController');
Route::resource('Commandes', 'CommandeController');
Route::resource('Origines', 'OrigineController');
Route::resource('Medicaments', 'medicamentsserviceController');
Route::resource('medicamentPartenaire', 'medicamentPartenaireController');
Route::get('/CorbAyantD', 'AyantDroitController@CorbAyantD')->name('CorbAyantD');

Route::get('/AffilierPartenaire', 'AffilierController@AffilierPartenaire')->name('AffilierPartenaire');

Route::put('/AffilierPatenerD', 'AffilierController@AffilierPatenerD')->name('AffilierPatenerD');
Route::get('/ChangerAdresse', 'ConsomationController@ChangerAdresse')->name('ChangerAdresse');
Route::put('/ModifierAdresse/{Adresse}', 'ConsomationController@ModifierAdresse')->name('ModifierAdresse');

Route::get('/CorbAffil', 'AffilierController@CorbAffil')->name('CorbAffil');

Route::get('/CorbFact', 'FactureController@CorbFact')->name('CorbFact');

Route::get('/CorbPaterner', 'PartenaireController@CorbPaterner')->name('CorbPaterner');

Route::get('/CorbCotisation', 'CotisationController@CorbCotisation')->name('CorbCotisation');

Route::get('/CorbUser', 'UtilisateurController@CorbUser')->name('CorbUser');

Route::get('/JournalC', 'CotisationController@Journal')->name('Journal');

Route::get('/JournalFacture', 'FactureController@JournalFacture')->name('JournalFacture');

Route::get('/RestaureAff/{Aff}', 'AffilierController@RestaureAff')->name('RestaureAff');

Route::get('/AttacherAff/{Service}', 'ServiceController@AttacherAff')->name('AttacherAff');
Route::get('/ChangerPrix/{Medicament}', 'medicamentsserviceController@ChangerPrix')->name('ChangerPrix');

Route::put('/ChangerPrixStore/{Medicament}', 'medicamentsserviceController@ChangerPrixStore')->name('StoreChange');

Route::delete('/SupprimerDef/{Affilier}', 'AffilierController@SupprimerDef')->name('SupprimerDef');
Route::delete('/SupprimerDefinitivement/{Facture}', 'FactureController@SupprimerDefini')->name('SupprimerDefini');
Route::delete('/SupprimerDefiniCot/{Cotisation}', 'CotisationController@SupprimerDefiniCot')->name('SupprimerDefiniCot');


Route::get('/SupprimerDefinitivement/{AyantsDroit}', 'AyantDroitController@SupprimerDefinitivement')->name('SupprimerDefinitivement');

Route::post('/AttacherAffStore', 'ServiceController@AttacherAffStore')->name('AttacherAffStore');

Route::get('Affiliers/addBillForm/{Aff}', 'AffilierController@addBillForm')->name('addBillForm');

Route::get('/RestaurerUser/{User}', 'UtilisateurController@RestaurerUser')->name('RestaurerUser');

Route::get('/Commandecreate/{User}', 'CommandeController@Commandecreate')->name('Commandecreate');

Route::get('/RestaureCot/{Cot}', 'CotisationController@RestaureCot')->name('RestaureCot');

Route::get('/RestaurePaterner/{Paterner}', 'PartenaireController@RestaurePaterner')->name('RestaurePaterner');

Route::get('/RestaureFact/{Facture}', 'FactureController@RestaureFact')->name('RestaureFact');

Route::get('/RestaureAyD/{AyD}', 'AyantDroitController@RestaureAyD')->name('RestaureAyD');
Route::resource('Utilisateurs', 'UtilisateurController');
Route::resource('AyantsDroit', 'AyantDroitController');
Route::resource('Cotisations', 'CotisationController');
Route::resource('Partenaires', 'PartenaireController');

Route::resource('Factures', 'FactureController');
Route::get('Ventillations/VentillationGeneral', 'VentillationController@VentillationGeneral')->name('VentillationGeneral');
Route::get('Ventillations/VentillationAutre', 'VentillationController@VentillationAutre')->name('VentillationAutre');
Route::post('Ventillations/CreateGroupe', 'VentillationController@CreateGroupe')->name('CreateGroupe');
Route::post('Ventillations/CreateGeneral', 'VentillationController@CreateGeneral')->name('CreateGeneral');

Route::get('Ventillations/VentillationIndividu', 'VentillationController@VentillationIndividu')->name('VentillationIndividu');

Route::get('Ventillations/ConsommationDetail', 'VentillationController@ConsommationDetail')->name('ConsommationDetail');

Route::get('Ventillations/VentillationGroupe', 'VentillationController@VentillationGroupe')->name('VentillationGroupe');

Route::post('Ventillations/CreateGroupe', 'VentillationController@CreateGroupe')->name('CreateGroupe');


Route::post('Ventillations/CreateIndividu', 'VentillationController@CreateIndividu')->name('CreateIndividu');

Route::get('Ventillations/PdfVentillationGeneral', 'VentillationController@PdfVentillationGeneral')->name('PdfVentillationGeneral');

Route::get('/PdfFacture/{Facture}', 'FactureController@PdfFacture')->name('PdfFacture');

Route::post('Affiliers/PdfListeAffilie', 'AffilierController@PdfListeAffilie')->name('PdfListeAffilie');

Route::get('Ventillations/PdfVentillationGroupe', 'VentillationController@PdfVentillationGroupe')->name('PdfVentillationGroupe');

Route::post('Ventillations/PdfCreateGeneral', 'VentillationController@PdfCreateGeneral')->name('PdfCreateGeneral');

Route::post('Cotisations/PdfCreateCotisation', 'CotisationController@PdfCreateCotisation')->name('PdfCreateCotisation');

Route::post('Factures/PdfCreateFactures', 'FactureController@PdfCreateFactures')->name('PdfCreateFactures');


Route::post('Ventillations/PdfCreateGroupe', 'VentillationController@PdfCreateGroupe')->name('PdfCreateGroupe');

Route::post('Ventillations/PdfCreateIndividu', 'VentillationController@PdfCreateIndividu')->name('PdfCreateIndividu');

Route::post('Ventillations/PdfViewDetails', 'VentillationController@PdfViewDetails')->name('PdfViewDetails');


Route::post('Affiliers/AffilierPartenaire', 'AffilierController@AffilierPartenaire')->name('AffilierPartenaire');

Route::get('/restaureMotDePasse/{User}', 'UtilisateurController@restaureMotDePasse')->name('restaureMotDePasse');

Route::get('/ModifierMotdePasse', 'UtilisateurController@ModifierMotdePasse')->name('ModifierMotdePasse');

Route::put('/updateProfil/{User}', 'UtilisateurController@updateProfil')->name('updateProfil');

Route::get('/ListeAffilier/{P}', 'PartenaireController@ListeAffilier')->name('ListeAffilier');

Route::get('graphic', 'TableauDeBordController@graphic')->name('graphic');
Route::get('consommer', 'TableauDeBordController@consommer')->name('consommer');
Route::get('ecart', 'TableauDeBordController@ecart')->name('ecart');
Route::get('dettePart', 'TableauDeBordController@dettePart')->name('dettePart');

Route::get('/TableauDeBord', 'TableauDeBordController@TableauDeBord')->name('TableauDeBord');


Route::post('AyantsDroit/research', 'AyantDroitController@research')->name('researchAyant');

Route::get('researchAy', 'AyantDroitController@researchAyantDroit')->name('researchAyantDroit');

Route::post('researchF', 'FactureController@research')->name('researchJournalFacture');
Route::get('researchC', 'CotisationController@research')->name('researchAffilierCotisation');
//Route::put('researchCP', 'CotisationController@research')->name('researchAffilierCotisation');
Route::get('researchV', 'VentillationController@research')->name('researchVentillationIndiv');
Route::get('researchA', 'AffilierController@research')->name('researchAffilier');

Route::get('researchArticle', 'medicamentsserviceController@research')->name('researchmedicament');
Route::get('/PdfAllMedicaments', 'medicamentsserviceController@PdfAllMedicaments')->name('PdfAllMedicaments');
Route::get('/Historique/{Medicament}', 'medicamentsserviceController@Historique')->name('Historique');
Route::post('/ImporterFile', 'medicamentsserviceController@ImporterFile')->name('ImporterFile');

Route::get('getOrigineId', 'OrigineController@getOrigineId')->name('getOrigineId');

Route::get('/Getimport/{Partenaire}', 'medicamentsserviceController@Getimport')->name('Getimport');
Route::post('/PostImport', 'medicamentsserviceController@PostImport')->name('PostImport');

Route::post('/perfomAction', 'OrigineController@perfomAction')->name('perfomAction');
Route::post('/uplodaAyantDroit', 'AyantDroitController@uplodaAyantDroit')->name('uplodaAyantDroit');

Route::get('/ExportMedicament', 'medicamentsserviceController@ExportMedicament')->name('ExportMedicament');
Route::get('/ExportExcelMedicament/{Partenaire}', 'medicamentsserviceController@ExportExcelMedicament')->name('ExportExcelMedicament');

Route::get('/elaborer_facture', 'FactureController@elaborer_facture')->name('elaborer_facture');



// ROUTES POUR LE MODULE DE COMPTABILITE

 Route::get('/index', 'ComptabiliteController@index')->name('index');
Route::resource('ExerciceComptable', 'ExerciceComptableController');
Route::resource('ComptePrincipal', 'ComptePrincipalController');
Route::resource('Comptedivisionnaire', 'CompteSudbivisionnaireController');
Route::resource('Journal', 'JournalController');
Route::resource('TypeCompte', 'TypeController');
Route::resource('CodeJournaux','CodeJournauxController');
Route::resource('CompteJournal','CompteJournalController');
Route::resource('CompteRepport','CompteRepportController');
Route::resource('Parametre_generaux','ParametreController');
Route::resource('Repportage','RepportageController');

Route::get('SaisieNouveauForm','CompteRepportController@SaisieNouveauForm')->name('SaisieNouveauForm');
Route::get('researchComptesReported', 'CompteRepportController@researchComptesReported')->name('researchComptesReported');
Route::get('PlanComptable', 'JournalController@PlanComptable')->name('PlanComptable');
Route::get('GrandLivre', 'JournalController@GrandLivre')->name('GrandLivre');
Route::get('Balance', 'JournalController@Balance')->name('Balance');

Route::get('research', 'JournalController@research')->name('researchSousComptes');
Route::get('research1', 'JournalController@research1')->name('researchSousComptes');
Route::get('research2', 'JournalController@research2')->name('researchSousComptes');
Route::get('research3', 'JournalController@research3')->name('researchComptes');
Route::get('research4', 'JournalController@research4')->name('researchJournal');

Route::post('AfficherGdLivre', 'JournalController@AfficherGdLivre')->name('AfficherGdLivre');
Route::post('AfficherBalance', 'JournalController@AfficherBalance')->name('AfficherBalance');

Route::get('CompteResultat', 'JournalController@CompteResultat')->name('CompteResultat');
Route::get('Bilan', 'JournalController@Bilan')->name('Bilan');
Route::get('JournalPdf', 'JournalController@JournalPdf')->name('JournalPdf');
Route::post('JournalPdf', 'JournalController@JournalPdf')->name('JournalPdf');
Route::post('BilanPdf', 'JournalController@BilanPdf')->name('BilanPdf');
Route::get('ResultatPdf', 'JournalController@ResultatPdf')->name('ResultatPdf');
Route::post('ResultatPdf', 'JournalController@ResultatPdf')->name('ResultatPdf');
Route::post('CloseExercice', 'ExerciceComptableController@CloseExercice')->name('CloseExercice');
Route::get('ReouvrirExercice/{ExerciceId}', 'ExerciceComptableController@ReouvrirExercice')->name('ReouvrirExercice');

Route::get('AddACount/{Journal}', 'CompteJournalController@AddACount')->name('AddACount');
Route::post('attachedAccount', 'CompteRepportController@attachedAccount')->name('attachedAccount');
Route::put('dettachedAccount', 'CompteRepportController@dettachedAccount')->name('dettachedAccount');
Route::get('SettedAccountAsRepported/{Compte}', 'CompteRepportController@SettedAccountAsRepported')->name('SettedAccountAsRepported');
Route::get('SettedAccountAsJournal/{Compte}', 'CodeJournauxController@SettedAccountAsJournal')->name('SettedAccountAsJournal');

Route::post('attachedJournal', 'CodeJournauxController@attachedJournal')->name('attachedJournal');
Route::put('dettacheJournal', 'CodeJournauxController@dettacheJournal')->name('dettacheJournal');

});



