@extends('layout.base', ['title' => 'Assurance - Nouveau Partenaire'])
@section('content')
        <div id="page-wrapper" >
            <div id="page-inner">
                <div class="row">
                    <div class="col-md-12">
        <h2 style="color: blue;font-weight: bold;text-align: center;">Importation des services</h2>
        <a href="{{route('ExportExcelMedicament', $Partenaire)}}" class="btn btn-primary">Export vers Excel</a>
        </div>
                </div>
                 <!-- /. ROW  -->
                 <hr />
               <div class="row">
                <div class="col-md-12">
                    <!-- Form Elements -->
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6">
<form role="form" method="POST" action="{{route('PostImport', $Partenaire)}}" enctype="multipart/form-data">
                                      {{ csrf_field() }}
                                       <div class="form-group">
                                            <label>Atacher un fichier Excel au format csv *</label>
                                            <input required="required" type="file" class="form-control" name="services" id="file" />

                                            {!! $errors->first('services', '<span class="error">:message</span>') !!}
                                        </div>
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuenow="" aria-valuemin="0" aria-valuemax="100" style="width: 0%">0%</div>
                                        </div>
                                        <br/>
                                           <div id="success">
                                               
                                           </div>
                                        <br/>
                                        <input hidden="hidden" type="text" name="Partenaire" value="{{$Partenaire}}">
                                        <label></label><br>
                                        <button type="submit" name="upload" value="upload" class="btn btn-primary">Import</button>
                                        <button type="reset" class="btn btn-default">Annuler</button>
                                
                                     
                                    </form>
                                    <br />                    
                             </div>

                             <div class="col-md-6" style="font-size: 20px;">
                                  <h3>NOTE IMPORTANTE</h3>
                                   Lisez attentivement avant d'importer le fichier.
                                   <ol>
                                       <li>Seul les fichiers Excel doivent etre importés</li>
                                       <li>Vérifier que le fichier est composé de ces 4 colonnes et écrites de la meme maniere (medicament, prix, code, designation)</li>
                                       <li>Rassurer vous que toutes ces colonnes sont remplies</li>
                                   </ol>

                                   <div>
                                       <img src="{{ url('icons/ExempleFicheExcel.png') }}">
                                   </div>
                             </div>

                            </div>
                        </div>
                    </div>
                     <!-- End Form Elements -->
                </div>
                                <div class="col-md-12">
                    <!-- Advanced Tables -->
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Ref. SAAT</th>
                                            <th>Ref.Partenaire</th>
                                            <th>Code</th>
                                            <th>Prix</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    {!! $tableListe !!}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
            </div>
    </div>
             <!-- /. PAGE INNER  -->
            </div>
         <!-- /. PAGE WRAPPER  -->
@endsection 
<script>
    $(document).ready(function(){
        $('form').ajaxForm({
          beforeSend:function(){
            $('success').empty();
          },
          UploadProgress:function(event, position, total, percentComplete){
            $('.progress-bar').text(percentComplete + '%');
            $('.progress-bar').css('width', percentComplete + '%');
          },
          success:function(data){
            if (data.errors) {
                $('.progress-bar').text('0%');
                $('.progress-bar').css('width', '0%');
                $('#success').html('<span class="text-danger"><b>'+data.errors+'</b></span>');
            }
            if (data.success) {
                $('.progress-bar').text('Uploaded');
                $('.progress-bar').css('width', '100%');
                $('#success').html('<span class="text-success"><b>'+data.success+'</b></span>');
            }
          }
        });
    });
</script>